% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addParents.R
\name{addParents}
\alias{addParents}
\title{Add parents}
\usage{
addParents(ped)
}
\arguments{
\item{ped}{datatable that is the \code{Pedigree}. It contains pedigree
information including the IDs listed in \code{candidates}.}
}
\value{
An updated pedigree with entries added as necessary.
Entries have the id and sex specified; all remaining columns are filled
with \code{NA}.
}
\description{
Pedigree curation function
Given a pedigree, find any IDs listed in the "sire" or "dam" columns
that lack their own line entry and generate one.
}
\details{
This must be run after to \code{addUIds} since the IDs made there are
used by \code{addParents}
}
\examples{
pedTwo <- data.frame(
  id = c("d1", "s2", "d2", "o1", "o2", "o3", "o4"),
  sire = c(NA, NA, NA, "s1", "s1", "s2", "s2"),
  dam = c(NA, NA, NA, "d1", "d2", "d2", "d2"),
  sex = c("F", "M", "F", "F", "F", "F", "M"),
  stringsAsFactors = FALSE
)
newPed <- addParents(pedTwo)
newPed

}
