% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chooseAllelesChar.R
\name{chooseAllelesChar}
\alias{chooseAllelesChar}
\title{Combines two vectors of alleles when alleles are character vectors.}
\usage{
chooseAllelesChar(a1, a2)
}
\arguments{
\item{a1}{vector with first parent alleles for each individual}

\item{a2}{vector with second parent alleles for each individual
\code{a1} and \code{a2} are equal length vectors of alleles for one
individual}
}
\value{
An integer vector with the result of sampling from \code{a1}
and \code{a2} according to Mendelian inheritance.
}
\description{
Combines two vectors by randomly selecting one allele
or the other at each position. Alleles may be of any class that
does not require attributes as the vectors are combined with \code{c()}.
}
\details{
The current implementation is slower than the one using integer vectors
(\code{chooseAlleles}).
}
