% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_slice.R
\name{nest_slice}
\alias{nest_slice}
\alias{nest_slice_head}
\alias{nest_slice_tail}
\alias{nest_slice_min}
\alias{nest_slice_max}
\alias{nest_slice_sample}
\title{Subset rows in nested data frames using their positions.}
\usage{
nest_slice(.data, .nest_data, ..., .preserve = FALSE)

nest_slice_head(.data, .nest_data, ...)

nest_slice_tail(.data, .nest_data, ...)

nest_slice_min(.data, .nest_data, order_by, ..., with_ties = TRUE)

nest_slice_max(.data, .nest_data, order_by, ..., with_ties = TRUE)

nest_slice_sample(.data, .nest_data, ..., weight_by = NULL, replace = FALSE)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g., a tibble), or a lazy
data frame (e.g., from dbplyr or dtplyr).}

\item{.nest_data}{A list-column containing data frames}

\item{...}{For \code{nest_slice()}: Integer row values.

Provide either positive values to keep, or negative values to drop. The
values provided must be either all positive or all negative. Indices beyond
the number of rows in the input are silently ignored.

For \code{nest_slice_helpers()}, these arguments are passed on to methods.

Additionally:
\itemize{
\item \code{n},\code{prop} Provide either \code{n}, the number of rows, or \code{prop}, the
proportion of rows to select. If neither are supplied, \code{n = 1} will be
used.

If a negative value of \code{n} or \code{prop} is provided, the specified number or
proportion of rows will be removed.

If \code{n} is greater than the number of rows in the group (or \code{prop > 1}), the
result will be silently truncated to the group size. If the proportion of a
group size does not yield an integer number of rows, the absolute value of
\code{prop*nrow(.nest_data)} is rounded down.
}}

\item{.preserve}{Relevant when \code{.nest_data} is grouped.
If \code{.preserve = FALSE} (the default), the grouping structure is
recalculated based on the resulting data, otherwise the grouping data is
kept as is.}

\item{order_by}{Variable or function of variables to order by.}

\item{with_ties}{Should ties be kept together? The default, \code{TRUE}, may
return more rows than you request. Use \code{FALSE} to ignore ties and return
the first \code{n} rows.}

\item{weight_by}{Sampling weights. This must evaluate to a vector of
non-negative numbers the same length as the input. Weights are automatically
standardised to sum to 1.}

\item{replace}{Should sampling be performed with (\code{TRUE}) or without (\code{FALSE},
the default) replacement?}
}
\value{
An object of the same type as \code{.data}. Each object in the column \code{.nest_data}
will also be of the same type as the input. Each object in \code{.nest_data} has
the following properties:
\itemize{
\item Each row may appear 0, 1, or many times in the output.
\item Columns are not modified.
\item Groups are not modified.
\item Data frame attributes are preserved.
}
}
\description{
\code{nest_slice()} lets you index rows in nested data frames by their (integer)
locations. It allows you to select, remove, and duplicate rows. It is
accompanied by a number of helpers for common use cases:
\itemize{
\item \code{nest_slice_head()} and \code{nest_slice_tail()} select the first or last rows
of each nested data frame in \code{.nest_data}.
\item \code{nest_slice_sample()} randomly selects rows from each data frame in
\code{.nest_data}.
\item \code{nest_slice_min()} and \code{nest_slice_max()} select the rows with the highest
or lowest values of a variable within each nested data frame in
\code{.nest_data}.
}

If \code{.nest_data} is a grouped data frame, the operation will be performed on
each group, so that (e.g.) \code{nest_slice_head(df, nested_dfs, n = 5)} will
return the first five rows in each group for each nested data frame.
}
\details{
\code{nest_slice()} and its helpers are largely wrappers for \code{\link[dplyr:slice]{dplyr::slice()}} and
its helpers and maintains the functionality of \code{slice()} and its helpers
within each nested data frame. For more information on \code{slice()} or its
helpers, please refer to the documentation in
\href{https://dplyr.tidyverse.org/}{\code{dplyr}}.
}
\examples{
gm_nest <- gapminder::gapminder \%>\% tidyr::nest(country_data = -continent)

# select the 1st, 3rd, and 5th rows in each data frame in country_data
gm_nest \%>\% nest_slice(country_data, 1, 3, 5)

# or select all but the 1st, 3rd, and 5th rows:
gm_nest \%>\% nest_slice(country_data, -1, -3, -5)

# first and last rows based on existing order:
gm_nest \%>\% nest_slice_head(country_data, n = 5)
gm_nest \%>\% nest_slice_tail(country_data, n = 5)

# rows with minimum and maximum values of a variable:
gm_nest \%>\% nest_slice_min(country_data, lifeExp, n = 5)
gm_nest \%>\% nest_slice_max(country_data, lifeExp, n = 5)

# randomly select rows with or without replacement:
gm_nest \%>\% nest_slice_sample(country_data, n = 5)
gm_nest \%>\% nest_slice_sample(country_data, n = 5, replace = TRUE)
}
\seealso{
Other single table verbs: 
\code{\link{nest_arrange}()},
\code{\link{nest_filter}()},
\code{\link{nest_mutate}()},
\code{\link{nest_rename}()},
\code{\link{nest_select}()},
\code{\link{nest_summarise}()}
}
\concept{single table verbs}
