% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNpde-distributionPlot.R
\name{npde.plot.loq}
\alias{npde.plot.loq}
\title{Plot of the probability that the observations are below the LOQ}
\usage{
npde.plot.loq(npdeObject,xaxis="x",nsim=200,...)
}
\arguments{
\item{npdeObject}{an object returned by a call to \code{\link{npde}} or \code{\link{autonpde}}}

\item{xaxis}{a string character, one of "x" (to plot P(Y<LOQ) versus the value of the independent predictor) or "ypred" (versus the value of the population predictions). Defaults to "x"}

\item{nsim}{number of simulations to be used for the computation of the prediction interval}

\item{\dots}{additional arguments to be passed on to the function, to control which metric (npde, pd, npd) is used or to override graphical parameters (see the PDF document for details, as well as \code{\link{set.plotoptions}})}
}
\value{
a ggplot object or a list of ggplot objects (grobs)
}
\description{
Plots the probability that the observations are below the LOQ along with the model predicted interval
}
\references{
K. Brendel, E. Comets, C. Laffont, C. Laveille, and F.
Mentre. Metrics for external model evaluation with an application to the
population pharmacokinetics of gliclazide. \emph{Pharmaceutical Research},
23:2036--49, 2006.
}
\seealso{
\code{\link{npde}}, \code{\link{autonpde}}, \code{\link{set.plotoptions}}
}
\author{
Emmanuelle Comets <emmanuelle.comets@bichat.inserm.fr>
}
\keyword{plot}
