% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncda.R
\name{ncda}
\alias{ncda}
\title{Nonparametric Clustered Data Analysis}
\usage{
ncda(formula,data,period,subject,indicator=NULL,Contrast=NULL)
}
\arguments{
\item{formula}{An object of class "formula" (or one that can be coerced to that class):
a symbolic description of the model to be fitted. The details of model specification are
given under ‘Details’.}

\item{data}{a data frame in the long format.}

\item{period}{time indicator variable.}

\item{subject}{subject or cluster ID}

\item{indicator}{an optional vector of characters indicating the order of pre and post intervention period;
must match the levels of period argument if specified; if not specified, the pre and post intervention
period will be ordered in the alphabet order by default}

\item{Contrast}{an optional contrast matrix for effect sizes.}
}
\value{
An object with effect sizes and other test details.
}
\description{
Main function to calculate nonparametric effect sizes and conduct hypothesis tests.
}
\details{
The model has the form response ~ tx where response is the (numeric)
response variable and tx is the treatment variable.
}
\examples{
\donttest{
ARTIS_analysis <- ncda(symptoms_pqol~tx, ARTIS, intervention, homeid,
                        indicator=c("0","1"),
                        Contrast=matrix(c(1,-1,1,-1,1,-1), nrow = 1))
names(ARTIS_analysis)
ARTIS_analysis$p.vector
}
skin_analysis <- ncda(score~tx, skin, intervention, subject,
                      indicator=c("control","treatment"),
                      Contrast=matrix(c(1,-1), nrow = 1))
skin_analysis$TotalSampleSize
skin_analysis$p.vector
}
\references{
Cui, Yue, Frank Konietschke, and Solomon W. Harrar. "The
nonparametric Behrens–Fisher problem in partially complete clustered data."
Biometrical Journal 63.1 (2021): 148-167.

Harrar, Solomon W., and Yue Cui. "Nonparametric methods for clustered data
in pre-post intervention design." Journal of Statistical Planning and
Inference 222 (2023): 1-21.
}
