% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{seasonal.test}
\alias{seasonal.test}
\title{The Seasonal unit root tests function}
\usage{
seasonal.test(y,seasonal="ocsb",alpha=0.05)
}
\arguments{
\item{y}{a numeric vector or an object of the \code{ts} class containing a stationary time series.}

\item{seasonal}{A character string naming the desired seasonal unit root test for checking seasonality.
Valid values are \code{"ocsb"} for the Osborn, Chui, Smith, and Birchenhall, \code{"ch"} for the
Canova and Hansen, and \code{"hegy"} for Hylleberg, Engle, Granger, and Yoo. The default value is
\code{"ocsb"} for the Osborn, Chui, Smith, and Birchenhall test.}

\item{alpha}{Level of the test, possible values range from 0.01 to 0.1. By default \code{alpha = 0.05}
is used}
}
\value{
a h.test class with the main results of unit root hypothesis test.
}
\description{
Perform a seasonal unit root test to check seasonality in a linear stochastic process
}
\details{
Several different tests are available:
In the  \code{kpss} test, the null hypothesis that \code{y} has a stationary root
against a unit-root alternative. In the two remaining tests, the null hypothesis
is that \code{y} has a unit root against a stationary root alternative. By default,
 \code{alpha = 0.05} is used to select the more likely hypothesis.
}
\examples{
#  stationary  ar process
y = ts(rnorm(100),frequency = 6)
seasonal.test(y)

}
\references{
Osborn, D., Chui, A., Smith, J., & Birchenhall, C. (1988). Seasonality and the
order of integration for consumption. \emph{Oxford Bulletin of Economics
and Statistics}. 50(4), 361-377.

Canova, F. & Hansen, B. (1995). Are Seasonal Patterns Constant over Time? A Test
for Seasonal Stability. \emph{Journal of Business and Economic Statistics}.
13(3), 237-252.

Hylleberg, S., Engle, R., Granger, C. & Yoo, B. (1990). Seasonal integration
and cointegration. \emph{Journal of Econometrics} 44(1), 215-238.
}
\seealso{
\code{\link{normal.test}},\code{\link{uroot.test}}
}
\author{
Asael Alonzo Matamoros
}
