% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dat_col_names_optimus.R
\name{dat_col_names_optimus}
\alias{dat_col_names_optimus}
\title{Title: Attribute(s) naming function.}
\usage{
dat_col_names_optimus(
  df,
  rows_used = NULL,
  cols_used = NULL,
  user_specific_labels = NULL,
  read_direction = NULL
)
}
\arguments{
\item{df}{A data frame that requires attribute labels.}

\item{rows_used}{A character vector indicating the rows or tuples used on the microplate (usually a 96-well microplate). Initialized as NULL.}

\item{cols_used}{A numeric vector indicating the plate columns or attributes used. Initialized as NULL.}

\item{user_specific_labels}{A character vector where the user manually enters the used microplate wells based on the FLUOstar plate layout.}

\item{read_direction}{A string input with two choices, “vertical” or “horizontal.”
The user indicates “vertical” if the user intends to have a final data frame
with samples arranged as sample type triplets (A1, B1, C1, A1, B1, C1)
OR “horizontal” if the user intends to have a final data frame with samples}
}
\value{
Returns a character or numeric vector of attribute(s) names for the normalized data frame.
}
\description{
This function is used to name attribute(s).
Attribute(s) names, in this case, are equivalent to the well labels found on the microplate reader.
An attribute for a sample loaded into row A - column 1 will be named A1.
In short, the function takes a clean data frame and returns attribute names
that match the FLUOstar plate layout often presented as an Excel file.
}
\note{
Users are advised to input rows used but won’t be penalized for not doing so.
If the user provides the rows used, then attribute names are generated for the user.
The user must check to ensure that the names match the microplate layout.

The user can leave the columns used as NULL if the user loaded samples from column 1 and did so in sequence.
If the user fails to load in sequence from the first position, then the user must provide a numeric vector of columns used.

For instance, where the user skips columns, the user will be prompted to interact
with the program in order to ensure the final data frame has the correct attribute names.

The user can bypass the rows used and columns used parameters
if the user supplies a manually created character vector of the wells used in an experiment.

The read direction parameter is used to determine the presentation of the samples in the final data frame.
}
\examples{
fpath <- system.file("extdata", "dat_1.dat", package = "normfluodbf", mustWork = TRUE)
dat_df <- read.table(file=fpath)
nocomma_dat <- clean_odd_cc(dat_df)
resampled_scaled <- resample_dat_scale(nocomma_dat, tnp=3, cycles=40)
n = c('A','B','C')
sample_col_names <- dat_col_names_optimus(resampled_scaled, n)
}
\seealso{
\code{\link[=normfluodat]{normfluodat()}}, \code{\link[=dat_col_names_rigid]{dat_col_names_rigid()}}
}
\author{
Tingwei Adeck
}
