% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize}
\alias{normalize}
\alias{normalize.numeric}
\alias{normalize.matrix}
\alias{normalize.data.frame}
\alias{normalize.list}
\title{Centering and scaling of numeric data}
\usage{
normalize(x, center = TRUE, scale = TRUE, ...)

\method{normalize}{numeric}(x, center = TRUE, scale = TRUE, ...)

\method{normalize}{matrix}(
  x,
  center = TRUE,
  scale = TRUE,
  byrow = FALSE,
  ignore = integer(),
  jointly = list(),
  ...
)

\method{normalize}{data.frame}(
  x,
  center = TRUE,
  scale = TRUE,
  byrow = FALSE,
  ignore = integer(),
  jointly = list(),
  ...
)

\method{normalize}{list}(x, center = TRUE, scale = TRUE, ...)
}
\arguments{
\item{x}{an object to be normalized}

\item{center}{\code{TRUE} to normalize to zero mean or \code{FALSE} for no centering}

\item{scale}{\code{TRUE} to normalize to unit variance or \code{FALSE} for no scaling}

\item{...}{further arguments to be passed to or from other methods}

\item{byrow}{\code{TRUE} to normalize row-wise or \code{FALSE} to normalize column-wise}

\item{ignore}{an \code{integer} vector of column indices (or row indices if
\code{byrow = TRUE}) to not normalize}

\item{jointly}{a \code{list} of disjoint \code{integer} vectors of column indices (or row
indices if \code{byrow = TRUE}) to normalize jointly}
}
\value{
the normalized input \code{x} with the \code{numeric} centering and scaling
values used (if any) added as attributes \code{"center"} and \code{"scale"}
(ignored columns and rows get centering and scaling values of \code{NA})
}
\description{
normalize \code{numeric} data saved as a \code{vector}, \code{matrix},
\code{data.frame}, or \code{list} to have zero mean and / or unit variance
}
\examples{
# can normalize numeric vectors, matrices, data.frames, and lists of those
normalize(
  list(
    c(-3, 0, 3),
    matrix(1:12, nrow = 3, ncol = 4),
    data.frame(a = 1:3, b = 4:6, c = 7:9, d = 10:12)
  )
)

# can ignore columns (or rows)
normalize(
  data.frame(a = 1:3, b = c("A", "B", "C"), c = 7:9, d = 10:12),
  ignore = 2
)

# can normalize columns (or rows) jointly
normalize(
  matrix(1:12, nrow = 3, ncol = 4),
  jointly = list(1:2, 3:4)
)
}
