% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_GOFs.R
\name{do.one.GOF}
\alias{do.one.GOF}
\title{X-Y GOF-plot}
\usage{
do.one.GOF(data, x, y, color = "", add.loess = TRUE,
  refline = c("abline", "href0", "hrefmean", "hrefmedian", "none"),
  title = "", lines.by.id = FALSE, id.column = "ID", fx = NULL,
  fy = NULL, control = GOF.control())
}
\arguments{
\item{data}{data.frame to plot}

\item{x}{character string with name of column for x}

\item{y}{character string with name of column for y}

\item{color}{data columns to set different colors in plot, interpreted as factor}

\item{add.loess}{add loess smoother to plot (TRUE), or not (FALSE)}

\item{refline}{add reference line with intercept=0, slope=1 (abline), horizontal at y=0( href0), horizontal at y=mean of y( hrefmean), horizontal at y=median of y( hrefmedian), or don't add reference line (none)}

\item{title}{title}

\item{lines.by.id}{connect subjects by lines (TRUE), or don't (FALSE)}

\item{id.column}{column name that indicate subject identifier}

\item{fx}{function for transformation of x before plotting}

\item{fy}{function for transformation of y before plotting}

\item{control}{an optional list of control settings. See GOF.control for the names of the settable control values and their effect.}
}
\description{
X-Y GOF plot with reflines and data smoother and with caption added as reurned by get.caption
}
\examples{
# Get path to the example files included in nonmem2R package
file1 <- system.file("extdata", "sdtab999", package = "nonmem2R")
sdtab<-read.table(file=file1,skip=1,header=TRUE)
set.script.name("MyScript.R")
do.one.GOF(subset(sdtab,DV>0),"IPRED","DV")
}
