% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LoadNonmemOutput.R
\name{extload}
\alias{extload}
\title{Load final parameter values from a nonmem .ext output file.}
\usage{
extload(model, positive.iterations.only = T, last.table.only = T)
}
\arguments{
\item{model}{name of the ext file with or without the .ext extension.
model may include full or relative path to the ext file. See examples.}

\item{positive.iterations.only}{Include only rows with ITERATIONS>0 from MCMC and SEAM table results (default=TRUE)}

\item{last.table.only}{Include only the last table result for ext files with multiple table results}
}
\value{
Named list including theta, theta.sd, omega, omega.sd, sigma, sigma.sd, and ofv.
Here .sd is the vector(matrix) with standard errors estimated parameter values in theta(omega & sigma).

For MCMC output files each object are matrixes.
}
\description{
Load parameter values from a nonmem .ext output file.
For output files from FO, FOCE and IMP only the final parameter values are loaded.
For output tables of MCMC and SAEM all parameter values from ITERATIONS>0 will be loaded
unless positive.iterations=FALSE in case all the output from all iterations are loaded.

For ext-files with multiple table results either only the last table result is loaded (last.table.only=TRUE, default)
or all table result are loaded (last.table.only=FALSE).
All but the last table results are then returned as sub-lists to the last table result.
}
\examples{
##### Load the .ext file "run001.ext"
# 1) Get path to the example file included in nonmem2R package
file1 <- system.file("extdata", "run001.ext", package = "nonmem2R")
# 2) Load the file using the extload function
extload(file1)
}

