% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinal.R
\name{ordinal}
\alias{ordinal}
\alias{nom_ord}
\title{Convert numbers to ordinal character vectors (first, second, third)}
\usage{
ordinal(x, cardinal = TRUE, ...)

nom_ord(x, cardinal = TRUE, ...)
}
\arguments{
\item{x}{A numeric or character vector.}

\item{cardinal}{Whether to convert a numeric vector with \code{\link[=cardinal]{cardinal()}}
before applying ordinal suffixes.
When \code{TRUE}, 1 -> "first".
When \code{FALSE}, 1 -> "1st".
Defaults to \code{TRUE}.}

\item{...}{Further arguments passed to \code{\link[=cardinal]{cardinal()}} when \code{cardinal}
is \code{TRUE}.}
}
\value{
A character vector of the same length as \code{x}
}
\description{
Adds ordinal suffixes to numbers (or a character vector of number-like
words).
Converts numeric vectors to cardinal numbers before adding prefixes unless
\code{cardinal} is \code{FALSE}.
}
\examples{
nom_ord(2)
nom_ord(1:10)
nom_ord(525600)

nom_ord(1:10, cardinal = FALSE)
nom_ord(5:15, max_n = 10)

nom_ord(c("n", "dozen", "umpteen", "eleventy", "one zillion"))
nom_ord(9 + 3/4)
}
\seealso{
Other number names: 
\code{\link{adverbial}()},
\code{\link{cardinal}()},
\code{\link{collective}()},
\code{\link{denominator}()},
\code{\link{numerator}()},
\code{\link{ratio}()}
}
\concept{number names}
