% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimise_window_length.R
\name{optimise_window_length}
\alias{optimise_window_length}
\title{Optimise the elements per window for the count matrix approach}
\usage{
optimise_window_length(
  expression.matrix,
  method = "correlation_pearson",
  winlen.min = NULL,
  winlen.max = NULL,
  winlen.by = NULL,
  nstep.frac = 0.05,
  iternum = 1000,
  save.plot = NULL
)
}
\arguments{
\item{expression.matrix}{expression matrix, can be normalized or not}

\item{method}{one of the correlation or distance metrics to be used,
defaults to pearson correlation; list of all methods in
get_methods_correlation_distance()}

\item{winlen.min, winlen.max, winlen.by}{definition of the parameter search space}

\item{nstep.frac}{an alternative way to specify the step size, as a fraction of
the window length; default is 5\%}

\item{iternum}{number of iterations for the subsampling and calculation of JSE;
subsampling is needed because shorter windows have fewer points}

\item{save.plot}{name of the pdf in which to print the output plot
showing the distribution of JSE by window}
}
\value{
A single value of the optimal number of elements per window
}
\description{
This function optimises the number of elements per window
that is used in calculate_distance_matrices_counts(), by requiring
the distribution of correlations/distances to stabilise to a
uniform distribution. The Jensen-Shannon divergence is used to assess
the stability.
}
\examples{
optimise_window_length(
matrix(1:100+runif(100), ncol=5, byrow=TRUE),
  winlen.min=3, winlen.max=5, iternum=5)
}
