% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{EV.nnct}
\alias{EV.nnct}
\title{Expected Values of the Cell Counts in NNCT}
\usage{
EV.nnct(ct)
}
\arguments{
\item{ct}{A nearest neighbor contingency table}
}
\value{
A \code{matrix} of the expected values of cell counts in the NNCT.
}
\description{
Returns a \code{matrix} of same dimension as, \code{ct}, whose entries are the expected cell counts of
the NNCT under RL or CSR. The class sizes given as the row sums of \code{ct} and the row and column names are
inherited from \code{ct}.

See also (\insertCite{dixon:1994,ceyhan:eest-2010;textual}{nnspat}).
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

EV.nnct(ct)

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ct<-nnct(ipd,fcls)
EV.nnct(ct)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

EV.nnct(ct)

ct<-matrix(c(0,10,5,5),ncol=2)
EV.nnct(ct)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{nnct}} and \code{\link{EV.tct}}
}
\author{
Elvan Ceyhan
}
