% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MULTI.loading_helper.R
\name{getMULTI.loadings}
\alias{getMULTI.loadings}
\title{Get Factor Loadings for a Multivariate Longitudinal Outcomes with Specified Functional Curves}
\usage{
getMULTI.loadings(y_model, t_var, y_var, curveFun, intrinsic, records)
}
\arguments{
\item{y_model}{A string specifying how to fit the longitudinal outcome. Supported values are \code{"LGCM"} and \code{"LCSM"}.
It takes the value passed from \code{getMGM()}.}

\item{t_var}{A vector of strings, with each element representing the prefix for column names related to the time
variable for the corresponding outcome variable at each study wave. It takes the value passed from \code{getMGM()}.}

\item{y_var}{A vector of strings, with each element representing the prefix for column names corresponding to a
particular outcome variable at each study wave. It takes the value passed from \code{getMGM()}.}

\item{curveFun}{A string specifying the functional form of the growth curve. Supported options for \code{y_model =
"LGCM"} include: \code{"linear"} (or \code{"LIN"}), \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"}
(or \code{"EXP"}), \code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"bilinear spline"} (or \code{"BLS"}). Supported
options for \code{y_model = "LCSM"} include: \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"}
(or \code{"EXP"}), \code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"nonparametric"} (or \code{"NonP"}). It takes the
value passed from \code{getMGM()}.}

\item{intrinsic}{A logical flag indicating whether to build an intrinsically nonlinear longitudinal model. It takes the
value passed from \code{getMGM()}.}

\item{records}{A list of numeric vectors, with each vector specifying the indices of the observed study waves for
the corresponding outcome variable. It takes the value passed from \code{getMGM()}.}
}
\value{
A list containing the specification of definition variables (i.e., individual time points for the latent
growth curve models, and individual time points and individual time lags (intervals) between adjacent time points
for latent change score models) and factor loadings of a multivariate longitudinal outcomes.
}
\description{
This function specifies the factor loadings for a multivariate longitudinal outcomes with a given functional form.
The longitudinal outcomes are fit by Latent Growth Curve Models or a Latent Change Score Models.
}
