% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbinom_vector.R
\name{dbinom_vector}
\alias{dbinom_vector}
\alias{rbinom_vector}
\title{Vectorized binomial distribution}
\usage{
dbinom_vector(x, size, prob, log = 0)

rbinom_vector(n = 1, size, prob)
}
\arguments{
\item{x}{Vector of quantiles.}

\item{size}{Vector of number of trials (zero or more).}

\item{prob}{Vector of success probabilities on each trial}

\item{log}{Logical argument, specifying whether to return the log-probability of the distribution.}

\item{n}{Number of observations. Only n = 1 is supported.}
}
\value{
The log-likelihood value associated with the vector of binomial observations.
}
\description{
The \code{dbinom_vector} distribution is a vectorized version of the binomial distribution.
It can be used to model a vector of binomial realizations. NB: using the vectorized version 
is beneficial only when the entire joint likelihood of the vector of binomial realizations (x)
is calculated simultaneously.
}
\examples{
## define vectorized model code
code <- nimbleCode({
    p ~ dunif(0,1)
    p_vector[1:J] <- p
    y[1:J] ~ dbinom_vector(size = trials[1:J],
                           prob = p_vector[1:J])
})
 
## simulate binomial data
J <- 1000
trials <- sample(x = 10, size = J, replace = TRUE)
y <- rbinom_vector(J, size = trials, prob = 0.21)
 
constants <- list(J = J, trials = trials)
 
data <- list(y = y)
 
inits <- list(p = 0.5)
 
## create NIMBLE model object
Rmodel <- nimbleModel(code, constants, data, inits)
 
## use model object for MCMC, etc.

}
\author{
Pierre Dupont
}
