% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/APT_functions.R
\name{sampler_APT}
\alias{sampler_APT}
\alias{sampler_RW_tempered}
\alias{sampler_RW_block_tempered}
\alias{sampler_slice_tempered}
\alias{sampler_RW_multinomial_tempered}
\alias{samplers}
\alias{sampler}
\title{A virtual function to use as a contains argument when writing APT samplers}
\usage{
sampler_APT()

sampler_RW_tempered(model, mvSaved, target, control)

sampler_RW_block_tempered(model, mvSaved, target, control)

sampler_slice_tempered(model, mvSaved, target, control)

sampler_RW_multinomial_tempered(model, mvSaved, target, control)
}
\arguments{
\item{model}{(uncompiled) model on which the APT algorithm is to be run}

\item{mvSaved}{\code{modelValues} object to be used to store MCMC samples}

\item{target}{node(s) on which the sampler will be used}

\item{control}{named list that controls the precise behavior of the sampler, with elements specific to \code{samplertype}.  The default values for control list are specified in the setup code of each sampling algorithm.  Descriptions of each sampling algorithm, and the possible customizations for each sampler (using the \code{control} argument) appear below.}
}
\value{
These functions are called from the \code{addSampler} function and return an uncompiled APT sampler object that can be included in an APT sampling scheme.
}
\description{
Modified from NIMBLE's samplers_BASE to include a setTemp method

Details of the adaptive parallel tempering (APT) samplers adapted from nimble's MCMC samplers.
}
\details{
Set up functions for this class should include the following arguments

APT samplers must include "contains = sampler_APT" and include a setTemp method
}
\section{\code{sampler_APT}}{
 base class for APT samplers

When you write a new sampler for use in a NIMBLE MCMC with APT, you must include \code{contains = sampler_APT}.
}

\section{RW sampler}{


The RW sampler executes adaptive Metropolis-Hastings sampling with a normal proposal distribution (Metropolis, 1953), implementing the adaptation routine given in Shaby and Wells, 2011.  This sampler can be applied to any scalar continuous-valued stochastic node, and can optionally sample on a log scale.

The RW sampler accepts the following control list elements:
\itemize{
\item logScale. A logical argument, specifying whether the sampler should operate on the log scale. (default = FALSE)
\item reflective. A logical argument, specifying whether the normal proposal distribution should reflect to stay within the range of the target distribution. (default = FALSE)
\item adaptive. A logical argument, specifying whether the sampler should adapt the scale (proposal standard deviation) throughout the course of MCMC execution to achieve a theoretically desirable acceptance rate. (default = TRUE)
\item adaptInterval. The interval on which to perform adaptation.  Every adaptInterval MCMC iterations (prior to thinning), the RW sampler will perform its adaptation procedure.  This updates the scale variable, based upon the sampler's achieved acceptance rate over the past adaptInterval iterations. (default = 200)
\item scale. The initial value of the normal proposal standard deviation.  If adaptive = FALSE, scale will never change. (default = 1)
\item temperPriors. Logical indicator determining if tempering should apply to prior likelihoods. Usually can be set to TRUE. But setting to FALSE can help avoid degeneracy issues for complex problems where bounded uniform priors have been transformed to other (e.g. logit) scales.
}

The RW sampler cannot be used with options log=TRUE and reflective=TRUE, i.e. it cannot do reflective sampling on a log scale.
}

\section{RW_block sampler}{


The RW_block sampler performs a simultaneous update of one or more model nodes, using an adaptive Metropolis-Hastings algorithm with a multivariate normal proposal distribution (Roberts and Sahu, 1997), implementing the adaptation routine given in Shaby and Wells, 2011.  This sampler may be applied to any set of continuous-valued model nodes, to any single continuous-valued multivariate model node, or to any combination thereof. \cr

The RW_block sampler accepts the following control list elements:
\itemize{
\item adaptive. A logical argument, specifying whether the sampler should adapt the scale (a coefficient for the entire proposal covariance matrix) and propCov (the multivariate normal proposal covariance matrix) throughout the course of MCMC execution.  If only the scale should undergo adaptation, this argument should be specified as TRUE. (default = TRUE)
\item adaptScaleOnly. A logical argument, specifying whether adaption should be done only for scale (TRUE) or also for provCov (FALSE).  This argument is only relevant when adaptive = TRUE.  When adaptScaleOnly = FALSE, both scale and propCov undergo adaptation; the sampler tunes the scaling to achieve a theoretically good acceptance rate, and the proposal covariance to mimic that of the empirical samples.  When adaptScaleOnly = TRUE, only the proposal scale is adapted. (default = FALSE)
\item adaptInterval. The interval on which to perform adaptation.  Every adaptInterval MCMC iterations (prior to thinning), the RW_block sampler will perform its adaptation procedure, based on the past adaptInterval iterations. (default = 200)
\item scale. The initial value of the scalar multiplier for propCov.  If adaptive = FALSE, scale will never change. (default = 1)
\item propCov. The initial covariance matrix for the multivariate normal proposal distribution.  This element may be equal to the character string 'identity', in which case the identity matrix of the appropriate dimension will be used for the initial proposal covariance matrix. (default = 'identity')
\item temperPriors. Logical indicator determining if tempering should apply to prior likelihoods. Usually can be set to TRUE. But setting to FALSE can help avoid degeneracy issues for complex problems where bounded uniform priors have been transformed to other (e.g. logit) scales.
}
}

\section{slice sampler}{


The slice sampler performs slice sampling of the scalar node to which it is applied (Neal, 2003).  This sampler can operate on either continuous-valued or discrete-valued scalar nodes.  The slice sampler performs a 'stepping out' procedure, in which the slice is iteratively expanded to the left or right by an amount sliceWidth.  This sampler is optionally adaptive, governed by a control list element, whereby the value of sliceWidth is adapted towards the observed absolute difference between successive samples.

The slice sampler accepts the following control list elements:
\itemize{
\item adaptive. A logical argument, specifying whether the sampler will adapt the value of sliceWidth throughout the course of MCMC execution. (default = TRUE)
\item adaptInterval. The interval on which to perform adaptation. (default = 200)
\item width. The initial value of the width of each slice, and also the width of the expansion during the iterative 'stepping out' procedure. (default = 1)
\item maxSteps. The maximum number of expansions which may occur during the 'stepping out' procedure. (default = 100)
}
}

\section{RW_multinomial sampler}{


This sampler is designed for sampling multinomial target distributions.  The sampler performs a series of Metropolis-Hastings steps between pairs of groups.  Proposals are generated via a draw from a binomial distribution, whereafter the proposed number density is moved from one group to another group.  The acceptance or rejection of these proposals follows a standard Metropolis-Hastings procedure.  Probabilities for the random binomial proposals are adapted to a target acceptance rate of 0.5.

The \code{RW_multinomial} sampler accepts the following control list elements:
\itemize{
\item adaptive.  A logical argument, specifying whether the sampler should adapt the binomial proposal probabilities throughout the course of MCMC execution. (default = TRUE)
\item adaptInterval.  The interval on which to perform adaptation.  A minimum value of 100 is required. (default = 200)
\item useTempering. A logical argument to optionally turn tempering off (i.e. assume all temperatures are 1) for this sampler.
}
}

\examples{
## This example is taken from the nimbleAPT vignette. See the vignette for more details.

bugsCode <- nimbleCode({
   for (ii in 1:nObs) {
       y[ii,1:2] ~ dmnorm(mean=absCentroids[1:2], cholesky=cholCov[1:2,1:2], prec_param=0)
   }
   absCentroids[1:2] <- abs(centroids[1:2])
   for (ii in 1:2) {
       centroids[ii] ~ dnorm(0, sd=1E3)
   }
})

nObs      <- 100
centroids <- rep(-3, 2)
covChol   <- chol(diag(2))

rModel <- nimbleModel(bugsCode,
                     constants=list(nObs=nObs, cholCov=covChol),
                     inits=list(centroids=centroids))

simulate(rModel, "y") ## Use model to simulate data

rModel <- nimbleModel(bugsCode,
                      constants=list(nObs=nObs, cholCov=covChol),
                      data=list(y=rModel$y),
                      inits=list(centroids=centroids))

conf <- configureMCMC(rModel, nodes="centroids", monitors="centroids", enableWAIC = TRUE)

conf$removeSamplers()
conf$addSampler("centroids[1]", type="sampler_RW_tempered", control=list(temperPriors=TRUE))
conf$addSampler("centroids[2]", type="sampler_RW_tempered", control=list(temperPriors=TRUE))
aptR <- buildAPT(conf, Temps=1:5, ULT= 1000, print=TRUE)

}
\references{
Metropolis, N., Rosenbluth, A. W., Rosenbluth, M. N., Teller, A. H., and Teller, E. (1953). Equation of State Calculations by Fast Computing Machines. \emph{The Journal of Chemical Physics}, 21(6), 1087-1092.

Neal, Radford M. (2003). Slice Sampling. \emph{The Annals of Statistics}, 31(3), 705-741.

Roberts, G. O. and S. K. Sahu (1997). Updating Schemes, Correlation Structure, Blocking and Parameterization for the Gibbs Sampler. \emph{Journal of the Royal Statistical Society: Series B (Statistical Methodology)}, 59(2), 291-317.

Shaby, B. and M. Wells (2011). \emph{Exploring an Adaptive Metropolis Algorithm}. 2011-14. Department of Statistics, Duke University.
}
\seealso{
\code{\link{configureMCMC}} \code{\link{addSampler}} \code{\link{buildMCMC}} \code{\link{buildAPT}} \code{\link{runMCMC}}
}
\author{
David Pleydell, Daniel Turek
}
