% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util-extract_niche_size.R
\name{extract_niche_size}
\alias{extract_niche_size}
\title{extract niche size}
\usage{
extract_niche_size(data, name = NULL, prob = NULL)
}
\arguments{
\item{data}{a \code{list} created by the function \code{niw.post()} in the package
\href{https://cran.r-project.org/package=nicheROVER}{{nicheROVER}}.}

\item{name}{a \code{character} string that will be assinged as the column name for
groups. Default is \code{sample_name}.}

\item{prob}{a \code{numeric} bound by 0 and 1 indicating the
probabilistic niche size. Default is 0.95.}
}
\value{
a \code{tibble} containing three rows, \code{sample_name}, \code{id}, and \code{niche_size}.
}
\description{
Extract niche size based on elliptical niche region of Bayesian estimates of
sigma created by function \code{niw.post()} in the package
\href{https://cran.r-project.org/package=nicheROVER}{{nicheROVER}}.
This function is a wrapper around \code{nicheROVER::niche.size}.
}
\examples{
extract_niche_size(data = niw_fish_post)


}
\seealso{
\code{\link[nicheROVER:niche.size]{nicheROVER::niche.size()}} and \code{\link[nicheROVER:niw.post]{nicheROVER::niw.post()}}
}
