% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ztdraw_sc_loglinear.R
\name{ztdraw_sc_loglinear}
\alias{ztdraw_sc_loglinear}
\title{Simulate from a zero-truncated non homogeneous Poisson Point Process (zt-NHPPP) from
(t_min, t_max) with a log-linear intensity function (inversion method)}
\usage{
ztdraw_sc_loglinear(
  alpha = 1,
  beta = 0,
  range_t = c(0, 10),
  rng_stream = NULL,
  atmost1 = FALSE
)
}
\arguments{
\item{alpha}{(double) the intercept in the exponent}

\item{beta}{(double) the slope in the exponent}

\item{range_t}{(vector, double) min and max of the time interval}

\item{rng_stream}{(\code{rstream}) an \code{rstream} object.}

\item{atmost1}{boolean, 1 event time}
}
\value{
a vector of at least 1 event times
}
\description{
Sample zt-NHPPP times from an log-linear intensity function
using the inversion method, optionally using an \code{rstream}
generator
}
\examples{
x <- ztdraw_sc_loglinear(alpha = 0, beta = 0.2)

}
