% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhl_schedule.R
\name{nhl_schedule}
\alias{nhl_schedule}
\alias{nhl_schedule_today}
\alias{nhl_schedule_seasons}
\alias{nhl_schedule_date_range}
\title{Retrieve metadata on NHL schedule from the API}
\usage{
nhl_schedule(seasons = NULL, teamIds = NULL, startDate = NULL,
  endDate = NULL, gameTypes = NULL, expand = NULL)

nhl_schedule_today(...)

nhl_schedule_seasons(seasons, ...)

nhl_schedule_date_range(startDate, endDate, ...)
}
\arguments{
\item{seasons}{\code{numeric()}, \code{integer()} or \code{character()},
vector of starting years of desired seasons in \code{YYYY}
format, e.g. \code{1995} or \code{"1995"} for season 1995-1996.
Accepts vectors such as \code{c(1995:2000, 2010)} to generate
multiple seasons.

Alternatively, also accepts \code{character()} with seasons in the
format \code{"YYYYZZZZ"}, where \code{ZZZZ = YYYY + 1}, e.g. \code{"19951996"}.
This is the format that ultimately gets sent to the NHL API.

Some API endpoints, notably \code{seasons} exposed via \code{\link[=nhl_seasons]{nhl_seasons()}}
also allow the value \code{"current"} to passed. This value will be
returned unchanged.}

\item{teamIds}{\code{integer()}, ids of the teams or \code{NULL} (default)
for all teams. As of end of 2019, the valid team ids seem to be
in the \code{1:54} range.}

\item{startDate}{\code{character(1)}, date in the format \code{"YYYY-MM-DD"}
defining the start of the date interval for which the schedule is
to be retrieved.}

\item{endDate}{\code{character(1)}, date in the format \code{"YYYY-MM-DD"}
defining the end of the date interval for which the schedule is
to be retrieved.}

\item{gameTypes}{\code{character()}, defining the game types to retrieve.
Valid game types are for example \code{"R"} for regular season or \code{"P"}
for playoffs. See \code{\link[=nhl_md_game_types]{nhl_md_game_types()}} for all values and their
descriptions.}

\item{expand}{\code{character()}, of parameters passed as \code{expand}
to the API URL. Some valid examples seem to be \code{"round.series"}
and \code{"schedule.broadcasts"}, \code{"schedule.linescore"},
\code{"schedule.ticket"}. \code{NULL} for no expand parameter.}

\item{...}{other named parameters passed to \code{\link[=nhl_schedule]{nhl_schedule()}}.}
}
\value{
\code{list}, with information on schedule, depending on
provided arguments.
}
\description{
The general-purpose \code{nhl_schedule()} exposes many parameters,
some useful helpers are exposed as separate functions to
reflect common use cases. Arguments can be passed to these
named via \code{...}.
\itemize{
\item \code{\link[=nhl_schedule_today]{nhl_schedule_today()}}
\item \code{\link[=nhl_schedule_seasons]{nhl_schedule_seasons()}}
\item \code{\link[=nhl_schedule_date_range]{nhl_schedule_date_range()}}
}
}
\section{Functions}{
\itemize{
\item \code{nhl_schedule_today}: Shortcut to get information on
today's schedule.

\item \code{nhl_schedule_seasons}: Shortcut to get information on schedule for
one or more seasons.

\item \code{nhl_schedule_date_range}: Shortcut to get information on
schedule for a range of dates in \code{"YYYY-MM-DD"} format.
}}

\examples{
\dontrun{
 # Get current schedule
 nhl_schedule()

 # Get schedule for historical seasons
 nhl_schedule(seasons = 2015:2016)

 # Get schedule for a date range
 nhl_schedule(startDate = "2018-01-02", endDate = "2018-01-02")

 # Get schedule for a date range, specific teams
 # and expand on line scores
 nhl_schedule(
   startDate = "2018-01-02",
   endDate = "2018-01-02",
   teamIds = c(29, 30),
   expand = "schedule.linescore"
 )
}

\dontrun{
  nhl_schedule_today()
}
\dontrun{
  # Schedule for seasons starting in 2015 and 2016
  nhl_schedule_seasons(2015:2016)

  # Schedule for seasons starting in 2015 and 2016
  # Only 1 team and expand line scores
  nhl_schedule_seasons(
    2015:2016,
    teamIds = 1,
    expand = "schedule.linescore"
  )
}
\dontrun{
  # Schedule for October and November 2015
  nhl_schedule_date_range(
    startDate = "2015-10-01",
    endDate = "2015-11-30"
  )

  # Schedule for October and November 2015
  # Regular seasons only, specific team and expand line scores
  nhl_schedule_date_range(
    startDate = "2015-10-01", endDate = "2015-11-30",
    gameTypes = "R",
    teamIds = 2,
    expand = "schedule.linescore"
  )
}
}
