% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_path_lengths.R
\name{get_path_lengths}
\alias{get_path_lengths}
\title{Get Path Lengths}
\usage{
get_path_lengths(outlets, network, cores = 1, status = FALSE)
}
\arguments{
\item{outlets}{vector of IDs from data.frame}

\item{network}{data.frame with ID, toID, and lengthkm attributes.}

\item{cores}{integer number of cores to use for parallel computation.}

\item{status}{logical print status and progress bars?}
}
\value{
data.frame containing the distance between pairs of network outlets.
For a network with one terminal outlet, the data.frame will have
`nrow(network)^2` rows.
}
\description{
Given a network and set of IDs, finds path lengths between all
identified flowpath outlets. This algorithm finds distance between outlets
regardless of flow direction.
}
\examples{
source(system.file("extdata", "walker_data.R", package = "nhdplusTools"))
fline <- walker_flowline

outlets <- c(5329303, 5329357, 5329317, 5329365, 5329435, 5329817)

# Add toCOMID
fline <- nhdplusTools::get_tocomid(fline, add = TRUE)

fl <- dplyr::select(fline, ID = comid, toID = tocomid, lengthkm)

path_lengths <- get_path_lengths(outlets, fl)

outlet_geo <- sf::st_sf(
  dplyr::left_join(data.frame(ID = outlets),
                   dplyr::select(fline, ID = comid), by = "ID"))

sf::st_geometry(outlet_geo) <- sf::st_geometry(nhdplusTools::get_node(outlet_geo))

plot(sf::st_geometry(fl))
plot(sf::st_geometry(outlet_geo), add = TRUE)

}
