% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_pbp.R
\name{load_pbp}
\alias{load_pbp}
\title{Load Play By Play}
\usage{
load_pbp(
  seasons = most_recent_season(),
  file_type = getOption("nflreadr.prefer", default = "rds")
)
}
\arguments{
\item{seasons}{A numeric vector of 4-digit years associated with given NFL seasons - defaults to latest season. If set to \code{TRUE}, returns all available data since 1999.}

\item{file_type}{One of \code{c("rds", "qs", "csv", "parquet")}. Can also be set globally with
\code{options(nflreadr.prefer)}}
}
\value{
The complete nflfastR dataset as returned by \code{nflfastR::build_nflfastR_pbp()}
(see below) for all given \code{seasons}
}
\description{
Loads play by play seasons from the \href{https://github.com/nflverse/nflverse-data}{nflverse-data repository}
}
\examples{
\donttest{
try({ # prevents cran errors
  load_pbp(2019:2020)
})
}
}
\seealso{
\url{https://nflreadr.nflverse.com/articles/dictionary_pbp.html} for a web version of the data dictionary

\code{\link{dictionary_pbp}} for the data dictionary bundled as a package dataframe

\url{https://www.nflfastr.com/reference/build_nflfastR_pbp.html} for the nflfastR function \code{nflfastR::build_nflfastR_pbp()}

Issues with this data should be filed here: \url{https://github.com/nflverse/nflverse-pbp}
}
