% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot.R
\docType{methods}
\name{plot_logratio}
\alias{plot_logratio}
\alias{plot,LogRatio,missing-method}
\title{Plot Log-Ratios}
\usage{
\S4method{plot}{LogRatio,missing}(
  x,
  ...,
  by = groups(x),
  color = palette_color_discrete(),
  rug = TRUE,
  ticksize = 0.05,
  ncol = NULL,
  flip = FALSE,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  ann = graphics::par("ann"),
  axes = TRUE,
  frame.plot = axes,
  legend = list(x = "top")
)
}
\arguments{
\item{x}{A \code{\linkS4class{LogRatio}} object.}

\item{...}{Further \link[graphics:par]{graphical parameters}, particularly,
\code{border} and \code{col}.}

\item{by}{A \code{vector} of grouping elements, as long as the variables in
\code{x}. If set, a matrix of panels defined by \code{groups} will be drawn.}

\item{color}{A palette \code{\link{function}} that when called with a single
argument returns a \code{character} vector of colors.}

\item{rug}{A \code{\link{logical}} scalar: should a \emph{rug} representation (1-d plot) of
the data be added to the plot?}

\item{ticksize}{A length-one \code{\link{numeric}} vector giving the length of the
ticks making up the \emph{rug}. Positive lengths give inwards ticks. Only used if
\code{rug} is \code{TRUE}.}

\item{ncol}{An \code{\link{integer}} specifying the number of columns to use.
Defaults to 1 for up to 4 groups, otherwise to 2.}

\item{flip}{A \code{\link{logical}} scalar: should the y-axis (ticks and numbering) be
flipped from side 2 (left) to 4 (right) from variable to variable?}

\item{xlab, ylab}{A \code{\link{character}} vector giving the x and y axis labels.}

\item{main}{A \code{\link{character}} string giving a main title for the plot.}

\item{ann}{A \code{\link{logical}} scalar: should the default annotation (title and x
and y axis labels) appear on the plot?}

\item{axes}{A \code{\link{logical}} scalar: should axes be drawn on the plot?}

\item{frame.plot}{A \code{\link{logical}} scalar: should a box be drawn around the
plot?}

\item{legend}{A \code{\link{list}} of additional arguments to be passed to
\code{\link[graphics:legend]{graphics::legend()}}; names of the list are used as argument names.
If \code{NULL}, no legend is displayed.}
}
\value{
\code{plot()} is called for its side-effects: is results in a graphic being
displayed (invisibly return \code{x}).
}
\description{
Displays a density plot.
}
\examples{
## Data from Day et al. 2011
data("kommos", package = "folio") # Coerce to compositional data
kommos <- remove_NA(kommos, margin = 1) # Remove cases with missing values
coda <- as_composition(kommos, groups = 1)

## Log ratio
clr <- transform_clr(coda)

## Density plot
plot(clr, by = NULL, flip = TRUE)

## Use ceramic types for grouping
plot(clr, flip = TRUE)
}
\seealso{
Other plot methods: 
\code{\link{as_graph}()},
\code{\link{barplot}()},
\code{\link{hist}()},
\code{\link{plot}()}
}
\author{
N. Frerebeau
}
\concept{plot methods}
