% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/statistics.R
\docType{methods}
\name{scale}
\alias{scale}
\alias{scale,CompositionMatrix-method}
\title{Scaling and Centering of Compositional Data}
\usage{
\S4method{scale}{CompositionMatrix}(x, center = TRUE, scale = TRUE)
}
\arguments{
\item{x}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{center}{A \code{\link{logical}} scalar or a \code{\link{numeric}} vector giving the center
to be substracted.}

\item{scale}{A \code{\link{logical}} scalar or a length-one \code{\link{numeric}} vector giving a
scaling factor for multiplication.}
}
\value{
A \code{\linkS4class{CompositionMatrix}} object.
}
\description{
Scaling and Centering of Compositional Data
}
\examples{
## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)

## Center and scale
scaled <- scale(coda, center = TRUE, scale = TRUE)
mean(scaled)
head(scaled)
}
\references{
Aitchison, J. (1986). \emph{The Statistical Analysis of Compositional Data}.
London: Chapman and Hall, p. 64-91.

Boogaart, K. G. van den & Tolosana-Delgado, R. (2013). \emph{Analyzing
Compositional Data with R}. Berlin Heidelberg: Springer-Verlag.
\doi{10.1007/978-3-642-36809-7}.
}
\seealso{
Other statistics: 
\code{\link{aggregate}()},
\code{\link{covariance}()},
\code{\link{dist}},
\code{\link{mahalanobis}()},
\code{\link{margin}()},
\code{\link{mean}()},
\code{\link{metric_var}()},
\code{\link{variation}()}
}
\author{
N. Frerebeau
}
\concept{statistics}
