% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replaceEmptyImageDimensions.R
\docType{methods}
\name{replaceEmptyImageDimensions-methods}
\alias{replaceEmptyImageDimensions-methods}
\alias{replaceEmptyImageDimensions}
\alias{replaceEmptyImageDimensions,nifti-method}
\alias{replaceEmptyImageDimensions,character-method}
\alias{replaceEmptyImageDimensions,factor-method}
\alias{replaceEmptyImageDimensions,list-method}
\alias{replaceEmptyImageDimensions,array-method}
\alias{replaceEmptyImageDimensions,anlz-method}
\alias{replaceEmptyImageDimensions,ANY-method}
\alias{replace_empty_dim}
\title{Replace Subsetting from Empty Image Dimensions}
\usage{
replaceEmptyImageDimensions(
  img,
  inds,
  target_dim,
  value = 0,
  reorient = FALSE,
  ...
)

\S4method{replaceEmptyImageDimensions}{nifti}(
  img,
  inds,
  target_dim,
  value = 0,
  reorient = FALSE,
  ...
)

\S4method{replaceEmptyImageDimensions}{character}(
  img,
  inds,
  target_dim,
  value = 0,
  reorient = FALSE,
  ...
)

\S4method{replaceEmptyImageDimensions}{factor}(
  img,
  inds,
  target_dim,
  value = 0,
  reorient = FALSE,
  ...
)

\S4method{replaceEmptyImageDimensions}{list}(
  img,
  inds,
  target_dim,
  value = 0,
  reorient = FALSE,
  ...
)

\S4method{replaceEmptyImageDimensions}{array}(
  img,
  inds,
  target_dim,
  value = 0,
  reorient = FALSE,
  ...
)

\S4method{replaceEmptyImageDimensions}{anlz}(
  img,
  inds,
  target_dim,
  value = 0,
  reorient = FALSE,
  ...
)

\S4method{replaceEmptyImageDimensions}{ANY}(
  img,
  inds,
  target_dim,
  value = 0,
  reorient = FALSE,
  ...
)

replace_empty_dim(img, ...)
}
\arguments{
\item{img}{image, nifti object, or array}

\item{inds}{indices of subset from \code{\link{getEmptyImageDimensions}} or
\code{\link{dropEmptyImageDimensions}}.}

\item{target_dim}{Original dimension from which the data was subset,
the final dimension of the output}

\item{value}{value to replace in the image where outside the indices}

\item{reorient}{Should image be reoriented if a filename?}

\item{...}{not used}
}
\value{
Object of class \code{nifti} or \code{array} if \code{nifti}
is not supplied
}
\description{
Simple wrapper for subsetting an image with indices, 
dropping empty dimensions.
}
\note{
\code{replace_empty_dim} is a shorthand for 
\code{replaceEmptyImageDimensions} with all the same arguments.
}
\examples{
dims = rep(10, 3)
arr = array(rnorm(prod(dims)), dim = dims)
arr[,,10] = 0
nim = oro.nifti::nifti(arr)
rnifti = RNifti::asNifti(nim)
timg = tempimg(nim)
limg = list(factor(timg, timg))
inds = getEmptyImageDimensions(nim)
inds_arr = getEmptyImageDimensions(arr)
testthat::expect_equal(inds, inds_arr)

out = applyEmptyImageDimensions(nim, inds = inds)
result = replaceEmptyImageDimensions(out, inds = inds,
target_dim = dim(nim))
testthat::expect_equal(array(result, dim = dim(result)), 
array(nim, dim = dim(nim)))
replace_empty_dim(out, inds = inds,
target_dim = dim(nim))

target_dim = dim(nim)

arr = array(out, dim = dim(out))
nim = oro.nifti::nifti(arr)
rnifti = RNifti::asNifti(nim)
timg = tempimg(nim)
limg = list(factor(timg), factor(timg))
func = function(...) replaceEmptyImageDimensions(..., 
target_dim = target_dim, inds = inds)
func(arr)
func(nim)
func(rnifti)
func(timg)
func(limg)
}
\seealso{
\code{\link{getEmptyImageDimensions}}, 
\code{\link{dropEmptyImageDimensions}}
}
