% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_print_plot.R
\name{plot.structure.impact}
\alias{plot.structure.impact}
\title{Plot "structure.impact" objects}
\usage{
\method{plot}{structure.impact}(x, order = c("given", "alphabetical",
  "value"), zscore = FALSE, abs_val = FALSE, ...)
}
\arguments{
\item{x}{an output object from an impact function (class \code{structure.impact})}

\item{order}{"alphabetical" orders nodes alphabetically, "value" orders nodes from
highest to lowest impact value}

\item{zscore}{logical. Converts raw impact statistics to z-scores for plotting}

\item{abs_val}{logical. Plot absolute values of network structure impacts.
If both abs_val=TRUE and zscore=TRUE, plots the absolute value of the z-scores.}

\item{...}{other plotting specifications (ggplot2)}
}
\description{
Convenience function for generating network structure impact plots
}
\details{
Inputting an object of class \code{network.impact}
will return a line plot that shows the relative network impacts of each node.
}
\examples{
out <- structure.impact(depression[,1:5])
plot(out)
\donttest{
out1 <- structure.impact(depression)
plot(out1)
plot(out1, order="value", zscore=TRUE)
out2 <- impact(depression)
plot(out2$Network.Structure)
}
}
