% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radialNetwork.R
\name{as.radialNetwork}
\alias{as.radialNetwork}
\title{Convert an R hclust or dendrogram object into a radialNetwork list.}
\usage{
as.radialNetwork(d, root)
}
\arguments{
\item{d}{An object of R class \code{hclust} or \code{dendrogram}.}

\item{root}{An optional name for the root node. If missing, use the first
argument variable name.}
}
\description{
\code{as.radialNetwork} converts an R hclust or dendrogram object into a list
suitable for use by the \code{radialNetwork} function.
}
\details{
\code{as.radialNetwork} coverts R objects of class \code{hclust} or
\code{dendrogram} into a list suitable for use with the \code{radialNetwork}
function.
}
\examples{
# Create a hierarchical cluster object and display with radialNetwork
## dontrun
hc <- hclust(dist(USArrests), "ave")
radialNetwork(as.radialNetwork(hc))

}

