% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank.analysis.R
\name{exact_rank_prob}
\alias{exact_rank_prob}
\title{Probabilistic centrality rankings}
\usage{
exact_rank_prob(P, only.results = T, verbose = F, force = F)
}
\arguments{
\item{P}{A partial ranking as matrix object calculated with \link{neighborhood_inclusion}
or \link{positional_dominance}.}

\item{only.results}{Logical. return only results (default) or additionally
the ideal tree and lattice if \code{FALSE}.}

\item{verbose}{Logical. should diagnostics be printed. Defaults to \code{FALSE}.}

\item{force}{Logical. If \code{FALSE} (default), stops the analysis if the partial
ranking has more than 40 elements and less than 0.4 comparable pairs.
Only change if you know what you are doing.}
}
\value{
\item{lin.ext}{Number of possible rankings that extend \code{P}.}
\item{mse}{Array giving the equivalence classes of \code{P}.}
\item{rank.prob}{Matrix containing rank probabilities: \code{rank.prob[u,k]} is the probability that u has rank k.}
\item{relative.rank}{Matrix containing relative rank probabilities: \code{relative.rank[u,v]} is the probability that u is ranked lower than v.}
\item{expected.rank}{Expected ranks of nodes in any centrality ranking.}
\item{rank.spread}{Standard deviation of the ranking probabilities.}
\item{topo.order}{Random ranking used to build the lattice of ideals (if \code{only.results = FALSE}).}
\item{tree}{Adjacency list (incoming) of the tree of ideals (if \code{only.results = FALSE}).}
\item{lattice}{Adjacency list (incoming) of the lattice of ideals (if \code{only.results = FALSE}).}
\item{ideals}{List of order ideals (if \code{only.results = FALSE}).}
In all cases, higher numerical ranks imply a higher position in the ranking. That is,
the lowest ranked node has rank 1.
}
\description{
Performs a complete and exact rank analysis of a given partial ranking.
This includes rank probabilities, relative rank probabilities and expected ranks.
}
\details{
The function derives rank probabilities from a given partial ranking
(for instance returned by \link{neighborhood_inclusion} or \link{positional_dominance}). This includes the
calculation of expected ranks, (relative) rank probabilities and the number of possible rankings.
Note that the set of rankings grows exponentially in the number of elements and the exact
calculation becomes infeasible quite quickly and approximations need to be used.
See \code{vignette("benchmarks")} for guidelines and \link{approx_rank_relative},
\link{approx_rank_expected}, and \link{mcmc_rank_prob} for approximative methods.
}
\examples{
P <- matrix(c(0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, rep(0, 10)), 5, 5, byrow = TRUE)
P
res <- exact_rank_prob(P)

# a warning is displayed if only one ranking is possible
tg <- threshold_graph(20, 0.2)
P <- neighborhood_inclusion(tg)
res <- exact_rank_prob(P)
}
\references{
De Loof, K. 2009. Efficient computation of rank probabilities in posets.
\emph{Phd thesis}, Ghent University.

De Loof, K., De Meyer, H. and De Baets, B., 2006. Exploiting the
lattice of ideals representation of a poset. \emph{Fundamenta Informaticae}, 71(2,3):309-321.
}
\seealso{
\link{approx_rank_relative}, \link{approx_rank_expected}, \link{mcmc_rank_prob}
}
\author{
David Schoch, Julian Müller
}
