% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_netmhc2pan.R
\name{run_netmhc2pan}
\alias{run_netmhc2pan}
\title{Run NetMHCIIpan}
\usage{
run_netmhc2pan(
  fasta_filename,
  alleles = "DRB1_0101",
  peptide_length = 15,
  netmhc2pan_folder_name = get_default_netmhc2pan_folder(),
  temp_xls_filename = netmhc2pan::create_temp_xls_filename()
)
}
\arguments{
\item{fasta_filename}{the name of a FASTA file with protein sequences}

\item{alleles}{one or more alleles, e.g. \code{DRB1_0101}.
See \link{get_netmhc2pan_alleles} for a full list}

\item{peptide_length}{length of a peptide}

\item{netmhc2pan_folder_name}{the folder (to be) used by NetMHCIIpan.
From this location, a subfolder for NetMHCIIpan is created.
Use \link{get_default_netmhc2pan_folder} to see the location
of the default NetMHCIIpan folder.
Use \link{get_default_netmhc2pan_subfolder} to see the location
of the default NetMHCIIpan subfolder.}

\item{temp_xls_filename}{name for a temporary \code{xls} file,
which will be deleted automatically}
}
\value{
a data frame with the NetMHCIIpan results
}
\description{
Run NetMHCIIpan
}
\examples{
if (is_netmhc2pan_installed()) {

  fasta_filename <- system.file(
    "extdata", "example.fasta", package = "netmhc2pan"
  )
  run_netmhc2pan(fasta_filename)

  # Two alleles
  alleles <- c("DRB1_0101", "DRB1_0102")
  # Run NetMHCpan with these two alleles
  run_netmhc2pan(fasta_filename, alleles = alleles)
}
}
\author{
Richèl J.C. Bilderbeek
}
