% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.netmeta.R
\name{summary.netmeta}
\alias{summary.netmeta}
\title{Summary method for objects of class netmeta}
\usage{
\method{summary}{netmeta}(
  object,
  fixed = object$fixed,
  random = object$random,
  prediction = object$prediction,
  reference.group = object$reference.group,
  baseline.reference = object$baseline.reference,
  all.treatments = object$all.treatments,
  warn.deprecated = gs("warn.deprecated"),
  ...
)
}
\arguments{
\item{object}{An object of class \code{netmeta}.}

\item{fixed}{A logical indicating whether results for the
fixed effects / common effects model should be printed.}

\item{random}{A logical indicating whether results for the
random effects model should be printed.}

\item{prediction}{A logical indicating whether prediction intervals
should be printed.}

\item{reference.group}{Reference treatment.}

\item{baseline.reference}{A logical indicating whether results
should be expressed as comparisons of other treatments versus the
reference treatment (default) or vice versa. This argument is
only considered if \code{reference.group} has been specified.}

\item{all.treatments}{A logical or \code{"NULL"}. If \code{TRUE},
matrices with all treatment effects, and confidence limits will
be printed.}

\item{warn.deprecated}{A logical indicating whether warnings should
be printed if deprecated arguments are used.}

\item{\dots}{Additional arguments (to catch deprecated arguments).}
}
\value{
A list is returned with the following elements:
\item{comparison}{Results for pairwise comparisons (data frame with
  columns studlab, treat1, treat2, TE, seTE, lower, upper, z, p).}
\item{comparison.nma.fixed}{Results for pairwise comparisons based
  on fixed effects model (data frame with columns studlab, treat1,
  treat2, TE, seTE, lower, upper, z, p, leverage).}
\item{comparison.nma.random}{Results for pairwise comparisons based
  on random effects model (data frame with columns studlab, treat1,
  treat2, TE, seTE, lower, upper, z, p).}
\item{fixed}{Results for fixed effects model (a list with elements
  TE, seTE, lower, upper, z, p).}
\item{random}{Results for random effects model (a list with
  elements TE, seTE, lower, upper, z, p).}
\item{predict}{Prediction intervals (a list with elements seTE,
  lower, upper).}
\item{studies}{Study labels coerced into a factor with its levels
  sorted alphabetically.}
\item{narms}{Number of arms for each study.}
\item{k}{Total number of studies.}
\item{m}{Total number of pairwise comparisons.}
\item{n}{Total number of treatments.}
\item{d}{Total number of designs (corresponding to the unique set
  of treatments compared within studies).}
\item{Q}{Overall heterogeneity / inconsistency statistic.}
\item{df.Q}{Degrees of freedom for test of heterogeneity /
  inconsistency.}
\item{pval.Q}{P-value for test of heterogeneity / inconsistency.}
\item{I2, lower.I2, upper.I2}{I-squared, lower and upper confidence
  limits.}
\item{tau}{Square-root of between-study variance.}
\item{Q.heterogeneity}{Overall heterogeneity statistic.}
\item{df.Q.heterogeneity}{Degrees of freedom for test of overall
  heterogeneity.}
\item{pval.Q.heterogeneity}{P-value for test of overall
  heterogeneity.}
\item{Q.inconsistency}{Overall inconsistency statistic.}
\item{df.Q.inconsistency}{Degrees of freedom for test of overall
  inconsistency.}
\item{pval.Q.inconsistency}{P-value for test of overall
  inconsistency.}
\item{sm}{A character string indicating underlying summary
  measure.}
\item{method}{A character string indicating which method is to be
  used for pooling of studies.}
\item{level}{The level used to calculate confidence intervals for
  individual studies.}
\item{level.ma}{The level used to calculate confidence intervals
  for pooled estimates.}
\item{fixed, random}{As defined above.}
\item{prediction, level.predict}{As defined above.}
\item{reference.group, baseline.reference}{As defined above.}
\item{all.treatments, backtransf}{As defined above.}
\item{ci.lab}{Label for confidence interval.}
\item{seq}{A character specifying the sequence of treatments.}
\item{tau.preset}{An optional value for the square-root of the
  between-study variance \eqn{\tau^2}.}
\item{sep.trts}{A character used in comparison names as separator
  between treatment labels.}
\item{nchar.trts}{A numeric defining the minimum number of
  characters used to create unique treatment names.}
\item{title}{Title of meta-analysis / systematic review.}
\item{call}{Function call.}
\item{version}{Version of R package netmeta used to create object.}
}
\description{
Summary method for objects of class \code{netmeta}.
}
\examples{
data(Senn2013)

# Conduct fixed effects network meta-analysis
#
net1 <- netmeta(TE, seTE, treat1, treat2, studlab,
                data = Senn2013, sm = "MD",
                random = FALSE)
print(net1, ref = "plac", digits = 3)
summary(net1)

\dontrun{
# Conduct random effects network meta-analysis
#
net2 <- netmeta(TE, seTE, treat1, treat2, studlab,
                data = Senn2013, sm = "MD",
                fixed = FALSE)
print(net2, ref = "plac", digits = 3)
summary(net2)
}

}
\seealso{
\code{\link{netmeta}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
\keyword{summary}
