% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moran.r
\name{moran}
\alias{moran}
\title{Computes Moran's I correlation index}
\usage{
moran(x, w, normalize.w = TRUE, alternative = "two.sided")
}
\arguments{
\item{x}{Numeric vector of size \eqn{n}.}

\item{w}{Numeric matrix of size \eqn{n\times n}{n * n}. Weights. It can be
either a object of class \code{\link{matrix}} or \code{\link[Matrix:dgCMatrix-class]{dgCMatrix}}
from the \code{\link[Matrix]{Matrix}} package.}

\item{normalize.w}{Logical scalar. When TRUE normalizes rowsums to one (or zero).}

\item{alternative}{Character String. Specifies the alternative hypothesis that
is tested against the null of no autocorrelation; must be of one \code{"two.sided"},
\code{"less"}, or \code{"greater"}.}
}
\value{
A list of class \code{diffnet_moran} with the following elements:
\item{observed}{Numeric scalar. Observed correlation index.}
\item{expected}{Numeric scalar. Expected correlation index equal to \eqn{-1/(N-1)}.}
\item{sd}{Numeric scalar. Standard error under the null.}
\item{p.value}{Numeric scalar. p-value of the specified \code{alternative}.}
}
\description{
Natively built for computing Moran's I on \code{dgCMatrix} objects, this
routine allows computing the I on large sparse matrices (graphs). Part of
its implementation was based on \code{\link[ape:Moran.I]{ape::Moran.I}},
which computes the I for dense matrices.
}
\details{
In the case that the vector \code{x} is close to constant (degenerate random
variable), the statistic becomes irrelevant, and furthermore, the standard error
tends to be undefined (\code{NaN}).
}
\examples{

\dontrun{

  # Generating a small random graph
  set.seed(123)
  graph <- rgraph_ba(t = 4)
  w <- approx_geodesic(graph)
  x <- rnorm(5)

  # Computing Moran's I
  moran(x, w)

  # Comparing with the ape's package version
  ape::Moran.I(x, as.matrix(w))

}

}
\references{
Moran's I. (2015, September 3). In Wikipedia, The Free Encyclopedia.
Retrieved 06:23, December 22, 2015, from \url{https://en.wikipedia.org/w/index.php?title=Moran\%27s_I&oldid=679297766}
}
\seealso{
Other statistics: \code{\link{bass}},
  \code{\link{classify_adopters}},
  \code{\link{cumulative_adopt_count}}, \code{\link{dgr}},
  \code{\link{ego_variance}}, \code{\link{exposure}},
  \code{\link{hazard_rate}}, \code{\link{infection}},
  \code{\link{struct_equiv}}, \code{\link{threshold}},
  \code{\link{vertex_covariate_dist}}

Other Functions for inference: \code{\link{bootnet}},
  \code{\link{struct_test}}
}
\author{
George G. Vega Yon
}
\concept{Functions for inference}
\concept{statistics}
