% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffnet-indexing.r
\name{diffnet_index}
\alias{diffnet_index}
\alias{[[.diffnet}
\alias{[[<-.diffnet}
\alias{[.diffnet}
\alias{[<-.diffnet}
\title{Indexing diffnet objects (on development)}
\usage{
\method{[[}{diffnet}(x, name, as.df = FALSE)

\method{[[}{diffnet}(x, i, j) <- value

\method{[}{diffnet}(x, i, j, k, drop = FALSE)

\method{[}{diffnet}(x, i, j, k) <- value
}
\arguments{
\item{x}{A diffnet class object.}

\item{name}{String vector. Names of the vertices attributes.}

\item{as.df}{Logical scalar. When \code{TRUE} returns a data frame, otherwise
a list of length \eqn{T}.}

\item{i}{Index of the i-th row of the adjacency matrix (see details).}

\item{j}{Index of the j-th column of the adjacency matrix (see details)}

\item{value}{Value to assign (see details)}

\item{k}{Index of the k-th slice of the adjacency matrix (see details).}

\item{drop}{Logical scalar. When \code{TRUE} returns an adjacency matrix, otherwise
a filtered diffnet object.}

\item{...}{Further argumnets to be passed to the method (on development)}
}
\value{
In the case of the assigning methods, a diffnet object. Otherwise,
for \code{[[.diffnet} a vector extracted from one of the attributes data frames,
and for \code{[.diffnet} a list of length \code{length(k)} with the corresponding
\code{[i,j]} elements from the adjacency matrix.
}
\description{
Access and assign (replace) elements from the adjacency matrices or the vertex
attributes data frames.
}
\details{
The \code{[[.diffnet} methods provides access to the diffnet attributes
data frames, static and dynamic. By providing the \code{name} of the corresponding
attribute, depending on whether it is static or dynamic the function will return
either a data frame--static attributes--or a list of these--dynamic attributes.
For the assigning method, \verb{[[<-.diffnet}, the function will infer what
kind of attribute is by analyzing the dimensions of \code{value}, in particular
we have the following possible cases:

\tabular{llr}{
\strong{Class}    \tab \strong{Dimension}   \tab \strong{Inferred} \cr
\code{matrix}     \tab \eqn{n\times T}{n*T} \tab Dynamic           \cr
\code{matrix}     \tab \eqn{n\times 1}{n*1} \tab Static            \cr
\code{matrix}     \tab \eqn{(n\times T)\times 1}{(n*T)*1} \tab Dynamic            \cr
\code{data.frame} \tab \eqn{n\times T}{n*T} \tab Dynamic           \cr
\code{data.frame} \tab \eqn{n\times 1}{n*1} \tab Static            \cr
\code{data.frame} \tab \eqn{(n\times T)\times 1}{(n*T)*1} \tab Dynamic            \cr
\code{vector}     \tab \eqn{n}              \tab Static            \cr
\code{vector}     \tab \eqn{n\times T}{n*T} \tab Dynamic           \cr
\code{list}*      \tab \eqn{T} data.frames/matrices/vectors\tab Dynamic    \cr
}
*: With \eqn{n\times 1}{n * 1} \code{data.frame}/\code{matrix} or \eqn{n} length vector.

Other cases will return with error.

In the case of the slices index \code{k}, either an
integer vector with the positions, a character vector with the labels of the
time periods or a logical vector of length \code{T} can be used to specify
which slices to retrieve. Likewise, indexing vertices works in the same way
with the only difference that, instead of time period labels and a logical vector
of length \code{T}, vertices ids labels and a logical vector of length \code{n}
should be provided.

When subsetting slices, the function modifies the \code{toa} vector as well as the
\code{adopt} and \code{cumadopt} matrices collapsing network tinmming. For example,
if a network goes from time 1 to 20 and we set \code{k=3:10}, all individuals
who adopted prior to time 3 will be set as adopters at time 3, and all individuals
who adopted after time 10 will be set as adopters at time 10, changing the
adoption and cumulative adoption matrices. Importantly, \code{k} have no
gaps, and it should be within the graph time period range.
}
\examples{

# Creating a random diffusion network ---------------------------------------
set.seed(111)
graph <- rdiffnet(100,5)

# Accessing to a static attribute
graph[["real_threshold"]]

# Accessing to subsets of the adjacency matrix
graph[1,,1:3, drop=TRUE]
graph[,,1:3, drop=TRUE]

# ... Now, as diffnet objects (the default)
graph[1,,1:3, drop=FALSE]
graph[,,1:3, drop=FALSE]

# Changing values in the adjacency matrix
graph[1, , , drop=TRUE]
graph[1,,] <- -5
graph[1, , , drop=TRUE]

# Adding attributes (dynamic) -----------------------------------------------
# Preparing the data
set.seed(1122)
x <- rdiffnet(30, 5, seed.p.adopt=.15)

# Calculating exposure, and storing it diffe
expoM <- exposure(x)
expoL <- lapply(seq_len(x$meta$nper), function(x) expoM[,x,drop=FALSE])
expoD <- do.call(rbind, expoL)

# Adding data (all these are equivalent)
x[["expoM"]] <- expoM
x[["expoL"]] <- expoL
x[["expoD"]] <- expoD

# Lets compare
identical(x[["expoM"]], x[["expoL"]]) # TRUE
identical(x[["expoM"]], x[["expoD"]]) # TRUE
}
\seealso{
Other diffnet methods: \code{\link{\%*\%}},
  \code{\link{as.array.diffnet}}, \code{\link{c.diffnet}},
  \code{\link{diffnet-arithmetic}},
  \code{\link{diffnet-class}}, \code{\link{plot.diffnet}},
  \code{\link{summary.diffnet}}
}
\author{
George G. Vega Yon
}
