% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffnet-methods.R
\name{diffnet-arithmetic}
\alias{&.diffnet}
\alias{*.diffnet}
\alias{-.diffnet}
\alias{/.diffnet}
\alias{^.diffnet}
\alias{diffnet-arithmetic}
\alias{graph_power}
\alias{|.diffnet}
\title{\code{diffnet} Arithmetic and Logical Operators}
\usage{
\method{^}{diffnet}(x, y)

graph_power(x, y, valued = getOption("diffnet.valued", FALSE))

\method{/}{diffnet}(y, x)

\method{-}{diffnet}(x, y)

\method{*}{diffnet}(x, y)

\method{&}{diffnet}(x, y)

\method{|}{diffnet}(x, y)
}
\arguments{
\item{x}{A \code{diffnet} class object.}

\item{y}{Integer scalar. Power of the network}

\item{valued}{Logical scalar. When FALSE all non-zero entries of the adjacency
matrices are set to one.}
}
\value{
A diffnet class object
}
\description{
Addition, substraction, network power of diffnet and logical operators such as
\code{&} and \code{|} as objects
}
\details{
Using binary operators, ease data management process with diffnet.

By default the binary operator \code{^} assumes that the graph is valued,
hence the power is computed using a weighted edges. Otherwise, if more control
is needed, the user can use \code{graph_power} instead.
}
\examples{
# Computing two-steps away threshold with the Brazilian farmers data --------
data(brfarmersDiffNet)

expo1 <- threshold(brfarmersDiffNet)
expo2 <- threshold(brfarmersDiffNet^2)

# Computing correlation
cor(expo1,expo2)

# Drawing a qqplot
qqplot(expo1, expo2)

# Working with inverse ------------------------------------------------------
brf2_step <- brfarmersDiffNet^2
brf2_step <- 1/brf2_step

# Removing the first 3 vertex of medInnovationsDiffnet ----------------------
data(medInnovationsDiffNet)

# Using a diffnet object
first3Diffnet <- medInnovationsDiffNet[1:3,,]
medInnovationsDiffNet - first3Diffnet

# Using indexes
medInnovationsDiffNet - 1:3

# Using ids
medInnovationsDiffNet - as.character(1001:1003)
}
\seealso{
Other diffnet methods: \code{\link{\%*\%}},
  \code{\link{as.array.diffnet}}, \code{\link{as_diffnet}},
  \code{\link{c.diffnet}}, \code{\link{diffnet_index}}
}

