% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nettest.R
\name{make.permute.moran}
\alias{make.permute.moran}
\title{Permutation Test of Moran's I}
\usage{
make.permute.moran(A, Y, np = 100)
}
\arguments{
\item{A}{\code{[n x n]} adjacency matrix or general relational weight matrix of which \eqn{A_ij} indicates relationship from \eqn{i} to \eqn{j}.}

\item{Y}{a vector of \eqn{n} continuous or binary, one-dimensional observations.}

\item{np}{the number of permutation samples.}
}
\value{
\item{\code{moran}}{a standardized Moran's \eqn{I} statistic.}
\item{\code{pval.z}}{p-value of a standardized Moran's \eqn{I} statistic assuming asymptotic normality.}
\item{\code{pval.permute}}{p-value of a standardized Moran's \eqn{I} statistic using \code{np} independent permutation samples.}
}
\description{
Permutation Test of Moran's I
}
\examples{
library(netdep)
library(igraph)
library(igraphdata)
data(karate)
A = as.matrix(get.adjacency(karate, attr= "weight", sparse = TRUE)) # weighted adjacency matrix
Y = V(karate)$Faction
result = make.permute.moran(A, Y, np = 100)


}
\author{
Youjin Lee
}
