% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_stats.R
\name{average_control}
\alias{average_control}
\title{\code{average_control} - Average controllability as defined by the trace of the Gramian}
\usage{
average_control(A, B)
}
\arguments{
\item{A}{A \eqn{n x n} matrix.}

\item{B}{A \eqn{n x m} matrix.}
}
\value{
Trace of the infinite time Gramian.
}
\description{
A commonly used measure \insertCite{pasqualettiControllabilityMetricsLimitations2014a}{netcontrol} of the overall controllability of a system defined by \eqn{x_(t+1) = Ax_(t) + Bu_(t)}.
}
\examples{
A = matrix(c(0,-3,-2,2,-2,1,-1,2,-1), 3,3)
B = diag(3)

average_control(A, B)
}
\references{
\insertRef{pasqualettiControllabilityMetricsLimitations2014a}{netcontrol}
}
