% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc_stats.R
\name{cc_stats}
\alias{cc_stats}
\title{Provide statistics on the CCs size}
\usage{
cc_stats(incM, cc.proteins, reducedIncM)
}
\arguments{
\item{incM}{a \code{logical} \code{matrix} containing the incidence matrix
with its column and row names (respectively, protein and peptide identifiers)
names and 0 or 1 values indicating whether or not the peptide maps on the
corresponding protein.}

\item{cc.proteins}{a \code{list} of \code{vectors} (one for each connected
component), each enumerating the proteins members of a connected component.}

\item{reducedIncM}{a \code{logical} value indicating if the input matrix is
the original complete incidence matrix or a reduced version of it which only
contains proteins with at least one shared peptide and all peptides mapping
on such proteins (generated by the \code{\link{reduce_inc_matrix}} function.}
}
\value{
a \code{list} of four outputs: i. a \code{vector} containing all
those proteins which belong to single-protein connected component (each
protein is a single-protein connected component); ii. an \code{integer}
representing the number of single-protein CCs; iii. an \code{integer}
representing the number of multi-protein CCs; iv. a \code{data.frame}
describing size distribution of connected components (number of connected
components per number of protein members)
}
\description{
Provides the CC size distribution, which is the number of CCs including a
given number of protein members, and the proportion of single- vs
multi-protein CCs.
}
\examples{
# Read the tab-delimited file containing he proteome incidence matrix
incM_filename <- system.file("extdata"
                             , "incM_example"
                             , package = "net4pg"
                             , mustWork = TRUE)
rownames_filename <- system.file("extdata"
                                  , "peptideIDs_incM_example"
                                  , package = "net4pg"
                                  , mustWork = TRUE)
colnames_filename <- system.file("extdata"
                                 , "proteinIDs_incM_example"
                                 , package = "net4pg"
                                 , mustWork = TRUE)
incM <- read_inc_matrix(incM_filename = incM_filename
                 , colnames_filename = colnames_filename
                 , rownames_filename = rownames_filename)
# Only retain proteins with at least one shared peptide and all peptides
# mapping on such proteins.
incM_reduced <- reduce_inc_matrix(incM)
# Generate adjacency matrix describing protein-to-protein mappings
adjM <- get_adj_matrix(incM_reduced)
# Generate graph of protein-to-protein connections and calculate its
# connected components
multProteinCC <- get_cc(adjM)
# CCs size and percentage of single-vs multi-protein CCs
CCstatsOut <- cc_stats(incM = incM_reduced
                      , cc.proteins = multProteinCC$ccs
                      , reducedIncM = TRUE)

}
\author{
Laura Fancello
}
