% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cypher.R
\name{multicypher}
\alias{multicypher}
\title{Run a multiple cypher queriers}
\usage{
multicypher(
  graph,
  queries,
  parameters = NULL,
  result = c("row", "graph"),
  arraysAsStrings = TRUE,
  eltSep = " || "
)
}
\arguments{
\item{graph}{the neo4j connection}

\item{queries}{queries to submit. It can be either a character vector
for which each element corresponds to a cypher query. Or it can be
a list of lists with the following slots:
\itemize{
\item \strong{query} (mandatory): A single character corresponding to the cypher
query.
\item \strong{parameters} (optional): A set of parameters specific for
this query. If not provided, the \emph{parameters} parameter of the function is
used  (see below).
\item \strong{result} (optional): The specific way to return the results of
this query. If not provided, the \emph{result} parameter of the function is
used  (see below).
}}

\item{parameters}{default parameters for the cypher queries.}

\item{result}{default way to return results. "row" will return a data frame
and "graph" will return a list of nodes, a list of relationships
and a list of paths (vectors of relationships identifiers).}

\item{arraysAsStrings}{if result="row" and arraysAsStrings is TRUE (default)
array from neo4j are converted to strings and array elements are
separated by eltSep.}

\item{eltSep}{if result="row" and arraysAsStrings is TRUE (default)
array from neo4j are converted to strings and array elementes are
separated by eltSep.}
}
\value{
a list of "result" of the queries (invisible).
See the "result" param.
}
\description{
Run a multiple cypher queriers
}
\examples{
\dontrun{
result <- multicypher(
   graph,
   queries=list(
      q1="match (n) return n.value limit 5",
      q2=list(
         query="match (f {value:$val})-[r]->(t) return f, r, t limit 5",
         result="graph",
         parameters=list(val=100)
      )
   )
)
}

}
\seealso{
\code{\link[=cypher]{cypher()}}, \code{\link[=startGraph]{startGraph()}}, \code{\link[=prepCql]{prepCql()}},
\code{\link[=readCql]{readCql()}} and \code{\link[=graphRequest]{graphRequest()}}
}
