% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse_ranges.R
\name{collapse_ranges}
\alias{collapse_ranges}
\title{Collapses the consecutive date or timestamp ranges into one record.}
\usage{
collapse_ranges(
  df,
  groups = NULL,
  start_var = NULL,
  end_var = NULL,
  startAttr = NULL,
  endAttr = NULL,
  dimension = "date",
  max_gap = 0L,
  fmt = "\%Y-\%m-\%d",
  tz = "UTC",
  origin = "1970-01-01"
)
}
\arguments{
\item{df}{Your data frame}

\item{groups}{Grouping variables}

\item{start_var}{Start of the range}

\item{end_var}{End of the range}

\item{startAttr}{Attributes linked to start of the range which should be kept (converted to character type by default)}

\item{endAttr}{Attributes linked to end of the range which should be kept (converted to character type by default)}

\item{dimension}{Indicate whether your range includes only dates ('date') or also timestamp ('timestamp'). Defaults to 'date'}

\item{max_gap}{Gap between date or timestamp ranges, e.g. for 0, default, it will put together all records where there is no gap in-between}

\item{fmt}{The format of your date or timestamp field, defaults to YMD}

\item{tz}{Time zone, defaults to UTC}

\item{origin}{Origin for timestamp conversion, defaults to 1970-01-01}
}
\value{
Returns a data frame (if initial input data.table, then data.table) with collapsed records.
}
\description{
The date/time ranges where the gap between two records is equal to or less than max_gap parameter are collapsed into one record.
}
\examples{
df_collapse <- data.frame(
id = c(rep("1111", 3), rep("2222", 3)),
rating = c("A+", "AA", "AA", rep("B-", 3)),
start_date = c("2014-01-01", "2015-01-01", "2016-01-01",
              "2017-01-01", "2018-01-01", "2019-01-01"),
end_date = c("2014-12-31", "2015-12-31", "2016-03-01",
            "2017-01-31", "2018-12-31", "2020-02-01")
            )

collapse_ranges(df_collapse, c("id", "rating"), "start_date", "end_date")
}
