% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bravo.R
\name{bravo}
\alias{bravo}
\title{Educational Isolation Index based on Bravo et al. (2021)}
\usage{
bravo(geo = "tract", year = 2020, subgroup, quiet = FALSE, ...)
}
\arguments{
\item{geo}{Character string specifying the geography of the data either census tracts \code{geo = "tract"} (the default) or counties \code{geo = "county"}.}

\item{year}{Numeric. The year to compute the estimate. The default is 2020, and the years 2009 onward are currently available.}

\item{subgroup}{Character string specifying the educational attainment category(ies). See Details for available choices.}

\item{quiet}{Logical. If TRUE, will display messages about potential missing census information. The default is FALSE.}

\item{...}{Arguments passed to \code{\link[tidycensus]{get_acs}} to select state, county, and other arguments for census characteristics}
}
\value{
An object of class 'list'. This is a named list with the following components:

\describe{
\item{\code{ei}}{An object of class 'tbl' for the GEOID, name, EI, and raw census values of specified census geographies.}
\item{\code{missing}}{An object of class 'tbl' of the count and proportion of missingness for each census variable used to compute EI.}
}
}
\description{
Compute the spatial Educational Isolation Index (Bravo) of selected educational attainment category(ies).
}
\details{
This function will compute the spatial Educational Isolation Index (EI) of U.S. census tracts or counties for a specified geographical extent (e.g., the entire U.S. or a single state) based on Bravo et al. (2021) \doi{10.3390/ijerph18179384} who originally designed the metric for the educational isolation of individual without a college degree. This function provides the computation of EI for any of the U.S. Census Bureau educational attainment levels.

The function uses the \code{\link[tidycensus]{get_acs}} function to obtain U.S. Census Bureau 5-year American Community Survey characteristics used for the geospatial computation. The yearly estimates are available for 2009 onward when ACS-5 data are available but are available from other U.S. Census Bureau surveys. The five educational attainment levels (U.S. Census Bureau definitions) are:
\itemize{
\item{B06009_002: }{Less than high school graduate "LtHS"}
\item{B06009_003: }{High school graduate (includes equivalency) "HSGiE"}
\item{B06009_004: }{Some college or associate's degree "SCoAD"}
\item{B06009_005: }{Bachelor's degree "BD"}
\item{B06009_006: }{Graduate or professional degree "GoPD"}
}
Note: If \code{year = 2009}, then the ACS-5 data (2005-2009) are from the "B15002" question.

Use the internal \code{state} and \code{county} arguments within the \code{\link[tidycensus]{get_acs}} function to specify geographic extent of the data output. NOTE: Current version does not correct for edge effects (e.g., census geographies along the specified spatial extent border, coastline, or U.S.-Mexico / U.S.-Canada border) may have few neighboring census geographies, and EI values in these census geographies may be unstable. A stop-gap solution for the former source of edge effect is to compute the EI for neighboring census geographies (i.e., the states bordering a study area of interest) and then use the estimates of the study area of interest.

A census geography (and its neighbors) that has nearly all of its population with the specified educational attainment category (e.g., a Bachelor's degree or more) will have an EI value close to 1. In contrast, a census geography (and its neighbors) that is nearly none of its population with the specified educational attainment category (e.g., less than a Bachelor's degree) will have an EI value close to 0.
}
\examples{
\dontrun{
# Wrapped in \dontrun{} because these examples require a Census API key.
  
  # Tract-level metric (2020)
  bravo(geo = "tract", state = "GA", 
        year = 2020, subgroup = c("LtHS", "HSGiE"))
  
  # County-level metric (2020)
  bravo(geo = "county", state = "GA",
        year = 2020, subgroup = c("LtHS", "HSGiE"))
  
}

}
\seealso{
\code{\link[tidycensus]{get_acs}} for additional arguments for geographic extent selection (i.e., \code{state} and \code{county}).
}
