% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCGroup.R
\docType{class}
\name{NCGroup}
\alias{NCGroup}
\title{NetCDF group}
\description{
This class represents a netCDF group, the object that holds
elements like dimensions and variables of a netCDF file. Additionally, the
group also holds references to any CF objects based on the netCDF elements
held by the group.
}
\details{
Direct access to groups is usually not necessary. The principal
objects held by the group, CF data variables and axes, are accessible via
other means. Only for access to the group attributes is a reference to a
group required.
}
\section{Fields}{

\describe{
\item{\code{resource}}{Access to the underlying netCDF resource.}

\item{\code{fullname}}{The fully qualified absolute path of the group.}

\item{\code{parent}}{Parent group of this group, \code{NULL} for the root group.}

\item{\code{subgroups}}{List of child \code{NCGroup}s of this group.}

\item{\code{NCvars}}{List of netCDF variables that are located in this group.}

\item{\code{NCdims}}{List of netCDF dimensions that are located in this group.}

\item{\code{NCUDTs}}{List of netCDF user-defined types that are located in this
group.}

\item{\code{CFvars}}{List of CF data variables in this group. There must be a
corresponding item in \code{NCvars} for each item in this list.}

\item{\code{CFaxes}}{List of axes of CF data variables in this group. There must be
a corresponding item in \code{NCvars} for each item in this list. Note that the
CF data variable(s) that an axis is associated with may be located in a
different group. Also, objects that further describe the basic axis
definition, such as its bounds, labels, ancillary data, may be located in a
different group; all such elements can be accessed directly from the
\link{CFAxis} instances that this list holds.}

\item{\code{CFaux}}{List of auxiliary variables. These could be \link{CFAxisScalar} or
\link{CFAuxiliaryLongLat} that hold longitude and latitude values for every grid
point in the data variable that references them.}
}}

