% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbc4va_internal.R
\name{internalGetCSMFMaxError}
\alias{internalGetCSMFMaxError}
\title{Calculate CSMF maximum error}
\usage{
internalGetCSMFMaxError(obs)
}
\arguments{
\item{obs}{Character vector of observed causes for each case.}
}
\value{
csmfMaxError Numeric value of the CSMF maximum error (see \code{\link{nbc4vaHelpMethods}}).
}
\description{
Calculates the CSMF maximum error given a set of observed cases.
}
\examples{
library(nbc4va)
obs <- c("HIV", "HIV", "Stroke", "Stroke")
maxerror <- nbc4va:::internalGetCSMFMaxError(obs)

}
\seealso{
Other internal functions: \code{\link{internalGetCSMFAcc}},
  \code{\link{internalGetCauseMetrics}},
  \code{\link{internalGetMetrics}},
  \code{\link{internalNBC}}
}
\keyword{internal}

