% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmtk-reformat.R
\name{cmtk.statistics}
\alias{cmtk.statistics}
\title{Calculate image statistics for a nrrd or other CMTK compatible file}
\usage{
cmtk.statistics(f, mask, imagetype = c("greyscale", "label"),
  masktype = c("label", "binary"), ..., Verbose = FALSE)
}
\arguments{
\item{f}{Path to image file (any CMTK compatible format)}

\item{mask}{Optional path to a mask file}

\item{imagetype}{Whether image should be treated as greyscale (default) or 
label field.}

\item{masktype}{Whether mask should be treated as label field or binary mask 
(default label)}

\item{...}{Additional arguments for ctmk's statistics tool processed by 
\code{\link{cmtk.call}}.}

\item{Verbose}{Whether to show cmtk status messages and be verbose about file
update checks. Sets command line \code{--verbose} option.}
}
\value{
data.frame describing results with the following columns when image
  \code{f} is of \code{imagetype='greyscale'} (optionally with a mask):
  
  \itemize{
  
  \item MaskLevel (only present when using a mask) the integer value of the 
  label field for this region
  
  \item min The minimum voxel value within the current region
  
  \item max The maximum voxel value within the current region
  
  \item mean The mean voxel value within the current region
  
  \item sdev The standard deviation of voxel values within the current region
  
  \item n The count of \bold{all} voxel within the region (irrespective of 
  their value)
  
  \item Entropy Information theoretic entropy of voxel value distribution 
  within region
  
  \item sum Sum of voxel values within the region
  
  }
  
  When image \code{f} is of \code{imagetype='label'}, the following results
  are returned:
  
  \itemize{
  
  \item level The integer value of the label field for this region
  
  \item count The number of voxels in this region
  
  \item surface The surface area of this region
  
  \item volume The volume of this region
  
  \item X,Y,Z 3D coordinates of the centroid of this region
  
  }
}
\description{
Calculate image statistics for a nrrd or other CMTK compatible file
}
\details{
When given a label mask, returns a dataframe with a row for each 
  level of the label field.

Note that the Entropy column (sometimes H, sometimes Entropy) will 
  always be named Entropy in the returned dataframe.
}
\examples{
\dontrun{
cmtk.statistics('someneuron.nrrd', mask='neuropilregionmask.nrrd')
cmtk.statistics('somelabelfield.nrrd', imagetype='label')
}
}
