% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reglist.R
\name{reglist}
\alias{c.reglist}
\alias{reglist}
\title{A simple wrapper class for multiple transformations}
\usage{
reglist(..., swap = NULL)

\method{c}{reglist}(..., recursive = FALSE)
}
\arguments{
\item{...}{One or more transformations/reglists to combine}

\item{swap}{A vector of the same length as \code{...} indicating whether the 
direction of each transformation should be swapped (i.e. mapping reference 
-> sample).}

\item{recursive}{Presently ignored}
}
\description{
A \code{reglist} is read as a set of transformations to be 
  applied sequentially starting with the first element, then applying the 
  second transformation to the result of the first and so on. Each individual
  transformation is considered to map data from the sample (floating/moving) 
  space to the reference (fixed/template) space.
  
  Each transformation may have an attribute \code{"swap"} indicating that the
  natural direction of the transformation should be swapped (i.e. inverted). 
  This can be done trivially in the case of affine transformations, 
  expensively for others such as CMTK registrations (see 
  \code{\link{cmtkreg}}) and not at all for others. Note that the term 'swap'
  is used to avoid a direct equivalence with inversion - many registration 
  tools use the term \emph{inverse} for directions that one might naively 
  think of as as the natural direction of the transformation (see 
  \code{\link{xformpoints.cmtkreg}} for discussion).

\code{c.reglist} combines multiple \code{reglist}s into a single
  \code{reglist}.
}
\details{
The swap argument is provided as a convenience, but an attribute
  \code{'swap'} can also be set directly on each registration.
}
\examples{
I=diag(4)
S=I
diag(S)=c(1, 2, 3, 1)
rl=reglist(S, I)
rl2=c(rl, 'path/to/my/reg.list')
rl3=c(reglist('path/to/my/reg.list'), rl)
}
\seealso{
\code{\link{xform}}

\code{\link[base]{c}}
}

