% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nrrd-io.R
\name{write.nrrd}
\alias{write.nrrd}
\alias{write.nrrd.header}
\alias{write.nrrd.header.for.file}
\title{Write data and metadata to NRRD file or create a detached NRRD (nhdr) file.}
\usage{
write.nrrd(
  x,
  file,
  enc = c("gzip", "raw", "text"),
  dtype = c("float", "byte", "short", "ushort", "int", "double"),
  header = attr(x, "header"),
  endian = .Platform$endian,
  datafile = NULL
)

write.nrrd.header(header, file)

write.nrrd.header.for.file(infile, outfile = NULL)
}
\arguments{
\item{x}{Data to write as an \code{array}, \code{vector} or 
\code{\link{im3d}} object.}

\item{file}{Character string naming an output file (a detached nrrd header 
when \code{file} has extension 'nhdr').}

\item{enc}{One of three supported nrrd encodings ("gzip", "raw", "text")}

\item{dtype}{The data type to write. One of "float","byte", "short", 
"ushort", "int", "double"}

\item{header}{List containing fields of nrrd header - see \emph{Header} 
section.}

\item{endian}{One of "big" or "little". Defaults to \code{.Platform$endian}.}

\item{datafile}{Optional name of separate file into which data should be 
written (see details).}

\item{infile, outfile}{Path to input and output file for 
\code{write.nrrd.header.for.file}. If \code{outfile} is \code{NULL} (the
default) then it will be set to \code{<infilestem.nhdr>}.}
}
\description{
\code{write.nrrd} writes an array, vector or im3d object to a 
  NRRD file. When \code{x} is an \code{im3d} object, appropriate spatial 
  calibration fields are added to the header.

\code{write.nrrd.header} writes a nrrd header file.

\code{write.nrrd.header.for.file} makes a detached NRRD
  (\bold{nhdr}) file that points at another image file on disk, making it
  NRRD compatible. This can be a convenient way to make NRRD inputs for other
  tools e.g. CMTK and also allows the same data block to pointed to by
  different nhdr files with different spatial calibration.
}
\section{Detached NRRDs}{
 NRRD files can be written in \emph{detached} format 
  (see \url{https://teem.sourceforge.net/nrrd/format.html#detached}) in which 
  a text \bold{nhdr} file is used to described the contents of a separate 
  (usually binary) data file. This means that the nhdr file can be inspected 
  and edited with a text editor, while the datablock can be in a completely 
  raw format that can be opened even by programs that do not understand the 
  NRRD format. Furthermore detached NRRD header files can be written to 
  accompany non-NRRD image data so that it can be opened by nrrd readers.
  
  If \code{file} has extension \code{.nhdr} \emph{or} \code{datafile} is 
  non-NULL, then \code{write.nrrd} will write a separate datafile. If 
  \code{datafile} is set, then it is interpeted as specifying a path relative
  to the \bold{nhdr} file. If \code{datafile} is not specified then default 
  filenames will be chosen according to the encoding following the 
  conventions of the teem library:
  
  \itemize{
  
  \item raw \code{'<nhdrstem>.raw'}
  
  \item gzip \code{'<nhdrstem>.raw.gz'}
  
  \item text \code{'<nhdrstem>.ascii'}
  
  }
}

\section{Data file paths}{
 When a detached NRRD is written, the 
  \code{datafile} can be specified either as \emph{relative} or 
  \emph{absolute} path. Relative paths are strongly recommended - the best 
  place is right next to the datafile. Relative paths are always specified 
  with respect to the location of the \bold{nhdr} file.
  
  The \code{datafile} argument is not processed by \code{write.nrrd} so it is
  up to the caller to decide whether a relative or absolute path will be 
  used.
  
  For \code{write.nrrd.header.for.file} if \code{outfile} is not specified 
  then the nhdr file will be placed next to the original image stack and the 
  \code{datafile} field will therefore just be \code{basename(infile)}. If 
  outfile is specified explicitly, then \code{datafile} will be set to the 
  full path in the \code{infile} argument. Therefore if you wish to specify 
  \code{outfile}, you \emph{must} set the current working directory (using 
  \code{setwd}) to the location in which \code{outfile} will be written to 
  ensure that the path to the datafile is correct. A future TODO would add 
  the ability to convert an absolute datafile path to a relaive one (by
  finding the common path between datafile and nhdr folders).
}

\section{Header}{
 For \code{write.nrrd}, arguments \code{enc}, \code{dtype}, 
  and \code{endian} along with the dimensions of the input (\code{x}) will 
  override the corresponding NRRD header fields from any supplied 
  \code{header} argument. See 
  \url{https://teem.sourceforge.net/nrrd/format.html} for details of the NRRD 
  fields.
}

\seealso{
\code{\link{read.nrrd}, \link{.Platform}}
}
