% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/im3d.R
\name{clampmax}
\alias{clampmax}
\title{Return function that finds maximum of its inputs within a clamping range}
\usage{
clampmax(xmin, xmax, replace.infinite = NA_real_)
}
\arguments{
  \item{xmin,xmax}{clamping range. If xmax is missing xmin
  should be a vector of length 2.}

  \item{replace.infinite}{The value with which to replace
  non-finite values \emph{in the input vector}. When
  code{replace.infinite=FALSE} no action is taken. The
  default value of \code{NA} will result in e.g. \code{Inf}
  being mapped to \code{NA}.}
}
\value{
A function with signature \code{f(x, ..., na.rm)}
}
\description{
Return function that finds maximum of its inputs within a
clamping range
}
\details{
Note that by default infinite values in the input vector
are converted to \code{NA}s before the being compared with
the clampmax range.
}
\examples{
\dontrun{
LHMask=read.im3d(system.file('tests/testthat/testdata/nrrd/LHMask.nrrd',package='nat'))
d=unmask(rnorm(sum(LHMask),mean=5,sd=5),LHMask)
op=par(mfrow=c(1,2))
rval=image(projection(d,projfun=max))
image(projection(d,projfun=clampmax(0,10)),zlim=rval$zlim)
par(op)
}
}

