% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_naptan.R
\name{call_naptan_region}
\alias{call_naptan_region}
\title{Call the Naptan API for a partial or full region name. Returns a data frame of Naptan data.}
\usage{
call_naptan_region(region_string)
}
\arguments{
\item{region_string}{string of partial or complete region name.
Function uses regex to search for provided string in the names of the regions in Naptan.

To see a data frame of current valid atco codes and region names, use the lookup_atco_codes() function.}
}
\value{
Returns a data frame of NaPTAN data containing transport access node information.
See \href{https://www.gov.uk/government/publications/national-public-transport-access-node-schema/naptan-and-nptg-data-sets-and-schema-guides}{NaPTAN data set guidance} for more information.
}
\description{
Call the Naptan API for a partial or full region name. Returns a data frame of Naptan data.
}
\examples{

#Return data for west yorkshire only 
call_naptan_region("west yorkshire")

#Return data for all yorkshire regions
call_naptan_region("yorkshire")


}
