% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{weakref}
\alias{weakref}
\alias{weakref_key}
\alias{weakref_value}
\title{Weak References}
\usage{
weakref(key, value)

weakref_key(w)

weakref_value(w)
}
\arguments{
\item{key}{a reference object (such as an environment or external pointer).}

\item{value}{an object.}

\item{w}{a weak reference.}
}
\value{
For \code{weakref}: a weak reference.

    For \code{weakref_key} and \code{weakref_value}: the key or value
    associated with the weak reference, or NULL if no longer reachable.
}
\description{
\code{weakref} creates a new weak reference - a special type of R object that
    associates a Value with a Key. Value is kept alive for as long as Key
    remains reachable (i.e. has yet to be garbage collected), even if Value
    itself no longer has any references.

\code{weakref_key} retrieves the key associated with a weak reference.

\code{weakref_value} retrieves the value associated with a weak reference.
}
\examples{
k <- new.env()
v <- "value"

w <- weakref(k, v)
w

key <- weakref_key(w)
identical(key, k)

value <- weakref_value(w)
identical(value, v)

rm(v)
weakref_value(w)

}
