% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sendrecv.R
\name{send}
\alias{send}
\title{Send}
\usage{
send(socket, data, mode = c("serial", "raw"), block = FALSE, echo = TRUE)
}
\arguments{
\item{socket}{a Socket.}

\item{data}{an object (if mode = 'raw', a vector).}

\item{mode}{[default 'serial'] whether data will be sent serialized or as a
raw vector. Use 'serial' for sending and receiving within R to ensure
perfect reproducibility. Use 'raw' for sending vectors of any type (will be
converted to a raw byte vector for sending) - essential when interfacing
with external applications.}

\item{block}{[default FALSE] logical flag whether to block until successful
or return immediately even if unsuccessful (e.g. no connection available).}

\item{echo}{[default TRUE] logical flag whether to return the raw vector of
sent data. Set to FALSE for performance-critical applications where zero
will be returned (invisibly) instead.}
}
\value{
Raw vector of sent data, or (invisibly) an integer exit code (zero on
    success) if 'echo' is set to FALSE.
}
\description{
Send data over a Socket.
}
\examples{
pub <- socket("pub", dial = "inproc://nanonext")

send(pub, data.frame(a = 1, b = 2))
send(pub, c(10.1, 20.2, 30.3), mode = "raw")

close(pub)

}
