% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n-prop-miss-complete-rows.R
\name{prop_complete_row}
\alias{prop_complete_row}
\title{Return a vector of the proportion of missing values in each row}
\usage{
prop_complete_row(data)
}
\arguments{
\item{data}{a dataframe}
}
\value{
numeric vector of the proportion of missing values in each row
}
\description{
Substitute for \code{rowMeans(!is.na(data))}, but it also checks if input is NULL or
is a dataframe
}
\examples{

prop_complete_row(airquality)
prop_complete_row(pedestrian)

}
\seealso{
\url{miss_case_pct} \url{miss_case_prop} \code{\link[=miss_prop_summary]{miss_prop_summary()}} \url{miss_case_summary} \url{miss_case_table} \url{miss_summary} \url{miss_var_pct} \url{miss_var_prop} \url{miss_var_run} \url{miss_var_span} \url{miss_var_summary} \url{miss_var_table} \url{n_complete} \url{n_complete_row} \url{n_miss} \url{n_miss_row} \url{pct_complete} \url{pct_miss} \url{prop_complete} \url{prop_complete_row} \url{prop_miss}
}
