% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-cols.R
\name{add_shadow_shift}
\alias{add_shadow_shift}
\title{Add a shadow shifted column to a dataset}
\usage{
add_shadow_shift(data, ..., suffix = "shift")
}
\arguments{
\item{data}{data.frame or .tbl}

\item{...}{One or more unquoted variable names separated by commas. These also
respect the dplyr verbs \code{starts_with}, \code{contains}, \code{ends_with}, etc.}

\item{suffix}{suffix to add to variable, defaults to "shift"}
}
\value{
data with the added variable shifted named as \code{var_suffix}
}
\description{
Shadow shift only the selected variables in a dataset by specifying variable
names or use dplyr \code{vars} and dplyr verbs \code{starts_with}, \code{contains},
\code{ends_with}, etc.
}
\examples{

pedestrian \%>\% add_shadow_shift(hourly_counts)

airquality \%>\% add_shadow_shift(Ozone, Solar.R)

}
