% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc_number.R
\name{cc_number_folder}
\alias{cc_number_folder}
\title{Cross-correlated number calculations for every image in a folder.}
\usage{
cc_number_folder(
  folder_path = ".",
  ch1 = 1,
  ch2 = 2,
  thresh = NULL,
  detrend = FALSE,
  quick = FALSE,
  filt = NULL,
  parallel = FALSE
)
}
\arguments{
\item{folder_path}{The path (relative or absolute) to the folder you wish to
process.}

\item{ch1}{A natural number. The index of the first channel to use.}

\item{ch2}{A natural number. The index of the second channel to use.}

\item{thresh}{Do you want to apply an intensity threshold prior to
calculating cross-correlated number (via
\code{\link[autothresholdr:mean_stack_thresh]{autothresholdr::mean_stack_thresh()}})? If so, set your thresholding method
here. If this is a single value, that same threshold will be applied to
both channels. If this is a length-2 vector or list, then these two
thresholds will be applied to channels 1 and 2 respectively. A value of
\code{NA} for either channel gives no thresholding for that channel.}

\item{detrend}{Detrend your data with \code{\link[detrendr:detrending]{detrendr::img_detrend_rh()}}. This is
the best known detrending method for brightness analysis. For more
fine-grained control over your detrending, use the \code{detrendr} package. To
detrend one channel and not the other, specify this as a length 2 vector.}

\item{quick}{\code{FALSE} repeats the detrending procedure (which has some inherent
randomness) a few times to hone in on the best detrend. \code{TRUE} is quicker,
performing the routine only once. \code{FALSE} is better.}

\item{filt}{Do you want to smooth (\code{filt = 'smooth'}) or median (\code{filt = 'median'}) filter the cross-correlated number image using \code{\link[=smooth_filter]{smooth_filter()}}
or \code{\link[=median_filter]{median_filter()}} respectively? If selected, these are invoked here with
a filter radius of 1 and with the option \code{na_count = TRUE}. A value of \code{NA}
for either channel gives no thresholding for that channel. If you want to
smooth/median filter the cross-correlated number image in a different way,
first calculate the cross-correlated numbers without filtering (\code{filt = NULL}) using this function and then perform your desired filtering routine
on the result.}

\item{parallel}{Would you like to use multiple cores to speed up this
function? If so, set the number of cores here, or to use all available
cores, use \code{parallel = TRUE}.}
}
\description{
Perform \code{\link[=cc_number]{cc_number()}} calculations on all TIFF images in a folder and
save the resulting images to disk.
}
\examples{
\dontrun{
setwd(tempdir())
ijtiff::write_tif(img, "a.tif")
ijtiff::write_tif(img, "ab.tif")
cc_number_folder()
list.files()
}
}
